/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.apache.xbean.finder.ClassFinder;
import org.springframework.stereotype.Component;

public class FilteredClassFinder {
    public static Set<Class<?>> findClasses(ClassFinder finder, Collection<String> packageNames) {
        return FilteredClassFinder.findClasses(finder, packageNames, new Class[]{Singleton.class, Component.class});
    }

    public static Set<Class<?>> findClasses(ClassFinder finder, Collection<String> packageNames, Class<? extends Annotation>[] annotations) {
        HashSet rawClasses = new HashSet();
        for (Class<? extends Annotation> annotation : annotations) {
            rawClasses.addAll(finder.findAnnotatedClasses(annotation));
        }
        return FilteredClassFinder.filterByBasePackages(rawClasses, packageNames);
    }

    private static Set<Class<?>> filterByBasePackages(Set<Class<?>> rawClasses, Collection<String> packageNames) {
        HashSet filteredClasses = new HashSet();
        for (Class<?> clazz : rawClasses) {
            for (String packageName : packageNames) {
                if (!clazz.getPackage().getName().startsWith(packageName)) continue;
                filteredClasses.add(clazz);
            }
        }
        return filteredClasses;
    }
}

