/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.url;

import java.util.Enumeration;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.apache.aries.jndi.url.AbstractName;

public final class OsgiName
extends AbstractName {
    private static final long serialVersionUID = 6617580228852444656L;
    public static final String OSGI_SCHEME = "osgi";
    public static final String ARIES_SCHEME = "aries";
    public static final String SERVICE_PATH = "service";
    public static final String SERVICES_PATH = "services";
    public static final String SERVICE_LIST_PATH = "servicelist";
    public static final String FRAMEWORK_PATH = "framework";

    public OsgiName(String name) throws InvalidNameException {
        super(OsgiName.split(name));
    }

    public OsgiName(Name name) throws InvalidNameException {
        this(name.toString());
    }

    public boolean hasFilter() {
        return this.size() == 3;
    }

    public boolean isServiceNameBased() {
        return this.size() > 3;
    }

    public String getInterface() {
        return this.get(1);
    }

    public String getFilter() {
        return this.hasFilter() ? this.get(2) : null;
    }

    public String getServiceName() {
        Enumeration<String> parts = this.getAll();
        parts.nextElement();
        StringBuilder builder = new StringBuilder();
        if (parts.hasMoreElements()) {
            while (parts.hasMoreElements()) {
                builder.append(parts.nextElement());
                builder.append('/');
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public boolean hasInterface() {
        return this.size() > 1;
    }
}

