/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.aries.spifly.pc.bundle;

import org.apache.aries.spifly.client.jar.Consumer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/** The activator invokes the SPI Consumer, which is also provided by this bundle. It does so
 * asynchronously to give the SPI-Fly extender a chance to register the provider, which is done
 * asynchronously as well.
 */
public class Activator implements BundleActivator {
    @Override
    public void start(BundleContext context) throws Exception {
        Thread t = new Thread(new Runnable() {
            @Override
            public void run() {
                System.out.println("*** Asynchronous invocation to let the extender do its work.");
                try {
                    Thread.sleep(500);
                } catch (InterruptedException e) {
                    // ignore
                }
                Consumer consumer = new Consumer();
                System.out.println("*** Result from invoking the SPI consumer via library: " + consumer.callSPI());
            }
        });
        t.start();
    }

    @Override
    public void stop(BundleContext context) throws Exception {
    }
}
