/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.dataflow;

import java.util.List;
import org.apache.asterix.common.ioopcallbacks.LSMIOOperationCallback;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;

public class LSMIndexUtil {
    private LSMIndexUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAndSetFirstLSN(AbstractLSMIndex lsmIndex, ILogManager logManager) throws HyracksDataException {
        if (lsmIndex.isCurrentMutableComponentEmpty()) {
            ILSMOperationTracker iLSMOperationTracker = lsmIndex.getOperationTracker();
            synchronized (iLSMOperationTracker) {
                if (lsmIndex.isCurrentMutableComponentEmpty()) {
                    LSMIOOperationCallback ioOpCallback = (LSMIOOperationCallback)lsmIndex.getIOOperationCallback();
                    ioOpCallback.setFirstLsnForCurrentMemoryComponent(logManager.getAppendLSN());
                }
            }
        }
    }

    public static void waitFor(List<? extends ILSMIOOperation> ioOperations) throws HyracksDataException {
        for (int i = 0; i < ioOperations.size(); ++i) {
            try {
                ioOperations.get(i).sync();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }
}

