/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.base;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;

public final class EquivalenceClass {
    private Set<ILogicalExpression> expressionMembers = new ListSet();
    private Set<LogicalVariable> members = new ListSet();
    private ILogicalExpression constRepresentative;
    private LogicalVariable variableRepresentative;
    private boolean representativeIsConst;

    public EquivalenceClass(Collection<LogicalVariable> members, ILogicalExpression constRepresentative) {
        this.members.addAll(members);
        this.constRepresentative = constRepresentative;
        this.representativeIsConst = true;
    }

    public EquivalenceClass(Collection<LogicalVariable> members, LogicalVariable variableRepresentative) {
        this.members.addAll(members);
        this.variableRepresentative = variableRepresentative;
        this.representativeIsConst = false;
    }

    public EquivalenceClass(Collection<LogicalVariable> members, ILogicalExpression constRepresentative, Collection<ILogicalExpression> expressionMembers) {
        this(members, constRepresentative);
        this.expressionMembers.addAll(expressionMembers);
    }

    public EquivalenceClass(Collection<LogicalVariable> members, LogicalVariable variableRepresentative, Collection<ILogicalExpression> expressionMembers) {
        this(members, variableRepresentative);
        this.expressionMembers.addAll(expressionMembers);
    }

    public boolean representativeIsConst() {
        return this.representativeIsConst;
    }

    public Collection<LogicalVariable> getMembers() {
        return this.members;
    }

    public Collection<ILogicalExpression> getExpressionMembers() {
        return this.expressionMembers;
    }

    public boolean contains(LogicalVariable var) {
        return this.members.contains(var);
    }

    public boolean contains(ILogicalExpression expr) {
        return this.expressionMembers.contains(expr);
    }

    public ILogicalExpression getConstRepresentative() {
        return this.constRepresentative;
    }

    public LogicalVariable getVariableRepresentative() {
        return this.variableRepresentative;
    }

    public void setConstRepresentative(ILogicalExpression constRepresentative) {
        this.constRepresentative = constRepresentative;
        this.representativeIsConst = true;
    }

    public void setVariableRepresentative(LogicalVariable variableRepresentative) {
        this.variableRepresentative = variableRepresentative;
        this.representativeIsConst = false;
    }

    public void merge(EquivalenceClass ec2) {
        this.members.addAll(ec2.getMembers());
        if (!this.representativeIsConst && ec2.representativeIsConst()) {
            this.representativeIsConst = true;
            this.constRepresentative = ec2.getConstRepresentative();
        }
        this.expressionMembers.addAll(ec2.getExpressionMembers());
    }

    public void addMember(LogicalVariable v) {
        this.members.add(v);
    }

    public EquivalenceClass cloneEquivalenceClass() {
        LinkedList<LogicalVariable> membersClone = new LinkedList<LogicalVariable>();
        membersClone.addAll(this.members);
        EquivalenceClass ec = this.representativeIsConst() ? new EquivalenceClass(membersClone, this.constRepresentative) : new EquivalenceClass(membersClone, this.variableRepresentative);
        return ec;
    }

    public String toString() {
        return "(<" + (this.representativeIsConst ? this.constRepresentative : this.variableRepresentative) + "> " + this.members + ";" + this.expressionMembers + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EquivalenceClass)) {
            return false;
        }
        EquivalenceClass ec = (EquivalenceClass)obj;
        if (!this.members.equals(ec.getMembers())) {
            return false;
        }
        if (!this.expressionMembers.equals(ec.getExpressionMembers())) {
            return false;
        }
        if (this.representativeIsConst) {
            return ec.representativeIsConst() && this.constRepresentative.equals(ec.getConstRepresentative());
        }
        return !ec.representativeIsConst() && this.variableRepresentative.equals(ec.getVariableRepresentative());
    }
}

