/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.Transceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketTransceiver
extends Transceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SocketTransceiver.class);
    private SocketChannel channel;
    private ByteBuffer header = ByteBuffer.allocate(4);
    private Protocol remote;

    public SocketTransceiver(SocketAddress address) throws IOException {
        this(SocketChannel.open(address));
    }

    public SocketTransceiver(SocketChannel channel) throws IOException {
        this.channel = channel;
        this.channel.socket().setTcpNoDelay(true);
        LOG.info("open to " + this.getRemoteName());
    }

    @Override
    public String getRemoteName() {
        return this.channel.socket().getRemoteSocketAddress().toString();
    }

    @Override
    public synchronized List<ByteBuffer> readBuffers() throws IOException {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        while (true) {
            ((Buffer)this.header).clear();
            while (this.header.hasRemaining()) {
                if (this.channel.read(this.header) >= 0) continue;
                throw new ClosedChannelException();
            }
            ((Buffer)this.header).flip();
            int length = this.header.getInt();
            if (length == 0) {
                return buffers;
            }
            ByteBuffer buffer = ByteBuffer.allocate(length);
            while (buffer.hasRemaining()) {
                if (this.channel.read(buffer) >= 0) continue;
                throw new ClosedChannelException();
            }
            ((Buffer)buffer).flip();
            buffers.add(buffer);
        }
    }

    @Override
    public synchronized void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        if (buffers == null) {
            return;
        }
        for (ByteBuffer buffer : buffers) {
            if (buffer.limit() == 0) continue;
            this.writeLength(buffer.limit());
            this.channel.write(buffer);
        }
        this.writeLength(0);
    }

    private void writeLength(int length) throws IOException {
        ((Buffer)this.header).clear();
        this.header.putInt(length);
        ((Buffer)this.header).flip();
        this.channel.write(this.header);
    }

    @Override
    public boolean isConnected() {
        return this.remote != null;
    }

    @Override
    public void setRemote(Protocol remote) {
        this.remote = remote;
    }

    @Override
    public Protocol getRemote() {
        return this.remote;
    }

    @Override
    public void close() throws IOException {
        if (this.channel.isOpen()) {
            LOG.info("closing to " + this.getRemoteName());
            this.channel.close();
        }
    }
}

