/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.lifecycle.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Observable;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileAccessor
extends Observable {
    private static final Log log = LogFactory.getLog(FileAccessor.class);
    File file = null;
    LifecycleManager manager;
    private int accessCount = 0;

    public FileAccessor(LifecycleManager manager, File file) {
        this.manager = manager;
        this.file = file;
    }

    public String getFileName() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getFileName()");
        }
        return this.file.getAbsolutePath();
    }

    public InputStream getInputStream() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getInputStream()");
        }
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getOutputStream()");
        }
        return new FileOutputStream(this.file);
    }

    public long getSize() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int getAccessCount() {
        return this.accessCount;
    }
}

