/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.code;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.openjdk.javax.lang.model.type.DeclaredType;
import org.openjdk.javax.lang.model.type.ExecutableType;
import org.openjdk.javax.lang.model.type.IntersectionType;
import org.openjdk.javax.lang.model.type.NoType;
import org.openjdk.javax.lang.model.type.NullType;
import org.openjdk.javax.lang.model.type.PrimitiveType;
import org.openjdk.javax.lang.model.type.TypeKind;
import org.openjdk.javax.lang.model.type.TypeMirror;
import org.openjdk.javax.lang.model.type.TypeVariable;
import org.openjdk.javax.lang.model.type.TypeVisitor;
import org.openjdk.javax.lang.model.type.UnionType;
import org.openjdk.tools.javac.code.AnnoConstruct;
import org.openjdk.tools.javac.code.Attribute;
import org.openjdk.tools.javac.code.BoundKind;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.TypeMetadata;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Infer;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Filter;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Pair;

public abstract class Type
extends AnnoConstruct
implements TypeMirror {
    protected final TypeMetadata metadata;
    public static final JCNoType noType = new JCNoType(){

        @Override
        public String toString() {
            return "none";
        }
    };
    public static final JCNoType recoveryType = new JCNoType(){

        @Override
        public String toString() {
            return "recovery";
        }
    };
    public static final JCNoType stuckType = new JCNoType(){

        @Override
        public String toString() {
            return "stuck";
        }
    };
    public static boolean moreInfo = false;
    public Symbol.TypeSymbol tsym;
    private static final Types.TypeMapping<Void> stripMetadata = new StructuralTypeMapping<Void>(){

        @Override
        public Type visitClassType(ClassType classType, Void void_) {
            return super.visitClassType((ClassType)classType.typeNoMetadata(), void_);
        }

        @Override
        public Type visitArrayType(ArrayType arrayType, Void void_) {
            return super.visitArrayType((ArrayType)arrayType.typeNoMetadata(), void_);
        }

        @Override
        public Type visitTypeVar(TypeVar typeVar, Void void_) {
            return (Type)super.visitTypeVar((TypeVar)typeVar.typeNoMetadata(), void_);
        }

        @Override
        public Type visitWildcardType(WildcardType wildcardType, Void void_) {
            return super.visitWildcardType((WildcardType)wildcardType.typeNoMetadata(), void_);
        }
    };

    public TypeMetadata getMetadata() {
        return this.metadata;
    }

    public TypeMetadata.Entry getMetadataOfKind(TypeMetadata.Entry.Kind kind) {
        return this.metadata != null ? this.metadata.get(kind) : null;
    }

    public boolean hasTag(TypeTag typeTag) {
        return typeTag == this.getTag();
    }

    public abstract TypeTag getTag();

    public boolean isNumeric() {
        return false;
    }

    public boolean isIntegral() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isPrimitiveOrVoid() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isNullOrReference() {
        return false;
    }

    public boolean isPartial() {
        return false;
    }

    public Object constValue() {
        return null;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public Type getModelType() {
        return this;
    }

    public static org.openjdk.tools.javac.util.List<Type> getModelTypes(org.openjdk.tools.javac.util.List<Type> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : list) {
            listBuffer.append(type.getModelType());
        }
        return listBuffer.toList();
    }

    public Type getOriginalType() {
        return this;
    }

    public <R, S> R accept(Visitor<R, S> visitor, S s) {
        return visitor.visitType(this, s);
    }

    public Type(Symbol.TypeSymbol typeSymbol, TypeMetadata typeMetadata) {
        Assert.checkNonNull(typeMetadata);
        this.tsym = typeSymbol;
        this.metadata = typeMetadata;
    }

    public <Z> Type map(Types.TypeMapping<Z> typeMapping, Z z) {
        return (Type)typeMapping.visit(this, z);
    }

    public <Z> Type map(Types.TypeMapping<Z> typeMapping) {
        return (Type)typeMapping.visit(this, null);
    }

    public Type constType(Object object) {
        throw new AssertionError();
    }

    public Type baseType() {
        return this;
    }

    protected Type typeNoMetadata() {
        return this.metadata == TypeMetadata.EMPTY ? this : this.baseType();
    }

    public abstract Type cloneWithMetadata(TypeMetadata var1);

    protected boolean needsStripping() {
        return false;
    }

    public Type stripMetadataIfNeeded() {
        return this.needsStripping() ? (Type)this.accept(stripMetadata, null) : this;
    }

    public Type stripMetadata() {
        return (Type)this.accept(stripMetadata, null);
    }

    public Type annotatedType(org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list) {
        TypeMetadata.Annotations annotations = new TypeMetadata.Annotations(list);
        return this.cloneWithMetadata(this.metadata.combine(annotations));
    }

    public boolean isAnnotated() {
        TypeMetadata.Annotations annotations = (TypeMetadata.Annotations)this.getMetadataOfKind(TypeMetadata.Entry.Kind.ANNOTATIONS);
        return null != annotations && !annotations.getAnnotations().isEmpty();
    }

    @Override
    public org.openjdk.tools.javac.util.List<Attribute.TypeCompound> getAnnotationMirrors() {
        TypeMetadata.Annotations annotations = (TypeMetadata.Annotations)this.getMetadataOfKind(TypeMetadata.Entry.Kind.ANNOTATIONS);
        return annotations == null ? org.openjdk.tools.javac.util.List.nil() : annotations.getAnnotations();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return null;
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> clazz) {
        Annotation[] annotationArray = (Annotation[])Array.newInstance(clazz, 0);
        return annotationArray;
    }

    public static org.openjdk.tools.javac.util.List<Type> baseTypes(org.openjdk.tools.javac.util.List<Type> list) {
        if (list.nonEmpty()) {
            Type type = ((Type)list.head).baseType();
            org.openjdk.tools.javac.util.List<Type> list2 = Type.baseTypes(list.tail);
            if (type != list.head || list2 != list.tail) {
                return list2.prepend(type);
            }
        }
        return list;
    }

    protected void appendAnnotationsString(StringBuilder stringBuilder, boolean bl) {
        if (this.isAnnotated()) {
            if (bl) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.getAnnotationMirrors());
            stringBuilder.append(" ");
        }
    }

    protected void appendAnnotationsString(StringBuilder stringBuilder) {
        this.appendAnnotationsString(stringBuilder, false);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendAnnotationsString(stringBuilder);
        if (this.tsym == null || this.tsym.name == null) {
            stringBuilder.append("<none>");
        } else {
            stringBuilder.append(this.tsym.name);
        }
        if (moreInfo && this.hasTag(TypeTag.TYPEVAR)) {
            stringBuilder.append(this.hashCode());
        }
        return stringBuilder.toString();
    }

    public static String toString(org.openjdk.tools.javac.util.List<Type> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((Type)list.head).toString());
        org.openjdk.tools.javac.util.List list2 = list.tail;
        while (list2.nonEmpty()) {
            stringBuilder.append(",").append(((Type)list2.head).toString());
            list2 = list2.tail;
        }
        return stringBuilder.toString();
    }

    public String stringValue() {
        Object object = Assert.checkNonNull(this.constValue());
        return object.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    public boolean equalsIgnoreMetadata(Type type) {
        return this.typeNoMetadata().equals(type.typeNoMetadata());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String argtypes(boolean bl) {
        org.openjdk.tools.javac.util.List<Type> list = this.getParameterTypes();
        if (!bl) {
            return list.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (list.tail.nonEmpty()) {
            stringBuilder.append(list.head);
            list = list.tail;
            stringBuilder.append(',');
        }
        if (((Type)list.head).hasTag(TypeTag.ARRAY)) {
            stringBuilder.append(((ArrayType)list.head).elemtype);
            if (((org.openjdk.tools.javac.util.List)((Type)list.head).getAnnotationMirrors()).nonEmpty()) {
                stringBuilder.append(((Type)list.head).getAnnotationMirrors());
            }
            stringBuilder.append("...");
        } else {
            stringBuilder.append(list.head);
        }
        return stringBuilder.toString();
    }

    public org.openjdk.tools.javac.util.List<Type> getTypeArguments() {
        return org.openjdk.tools.javac.util.List.nil();
    }

    public Type getEnclosingType() {
        return null;
    }

    public org.openjdk.tools.javac.util.List<Type> getParameterTypes() {
        return org.openjdk.tools.javac.util.List.nil();
    }

    public Type getReturnType() {
        return null;
    }

    public Type getReceiverType() {
        return null;
    }

    public org.openjdk.tools.javac.util.List<Type> getThrownTypes() {
        return org.openjdk.tools.javac.util.List.nil();
    }

    public Type getUpperBound() {
        return null;
    }

    public Type getLowerBound() {
        return null;
    }

    public org.openjdk.tools.javac.util.List<Type> allparams() {
        return org.openjdk.tools.javac.util.List.nil();
    }

    public boolean isErroneous() {
        return false;
    }

    public static boolean isErroneous(org.openjdk.tools.javac.util.List<Type> list) {
        org.openjdk.tools.javac.util.List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (((Type)list2.head).isErroneous()) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isCompound() {
        return false;
    }

    public boolean isIntersection() {
        return false;
    }

    public boolean isUnion() {
        return false;
    }

    public boolean isInterface() {
        return (this.tsym.flags() & 0x200L) != 0L;
    }

    public boolean isFinal() {
        return (this.tsym.flags() & 0x10L) != 0L;
    }

    public boolean contains(Type type) {
        return type.equalsIgnoreMetadata(this);
    }

    public static boolean contains(org.openjdk.tools.javac.util.List<Type> list, Type type) {
        org.openjdk.tools.javac.util.List<Type> list2 = list;
        while (list2.tail != null) {
            if (((Type)list2.head).contains(type)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    public boolean containsAny(org.openjdk.tools.javac.util.List<Type> list) {
        for (Type type : list) {
            if (!this.contains(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(org.openjdk.tools.javac.util.List<Type> list, org.openjdk.tools.javac.util.List<Type> list2) {
        for (Type type : list) {
            if (!type.containsAny(list2)) continue;
            return true;
        }
        return false;
    }

    public static org.openjdk.tools.javac.util.List<Type> filter(org.openjdk.tools.javac.util.List<Type> list, Filter<Type> filter) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : list) {
            if (!filter.accepts(type)) continue;
            listBuffer.append(type);
        }
        return listBuffer.toList();
    }

    public boolean isSuperBound() {
        return false;
    }

    public boolean isExtendsBound() {
        return false;
    }

    public boolean isUnbound() {
        return false;
    }

    public Type withTypeVar(Type type) {
        return this;
    }

    public MethodType asMethodType() {
        throw new AssertionError();
    }

    public void complete() {
    }

    public Symbol.TypeSymbol asElement() {
        return this.tsym;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.OTHER;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
        throw new AssertionError();
    }

    public static interface Visitor<R, S> {
        public R visitClassType(ClassType var1, S var2);

        public R visitWildcardType(WildcardType var1, S var2);

        public R visitArrayType(ArrayType var1, S var2);

        public R visitMethodType(MethodType var1, S var2);

        public R visitPackageType(PackageType var1, S var2);

        public R visitModuleType(ModuleType var1, S var2);

        public R visitTypeVar(TypeVar var1, S var2);

        public R visitCapturedType(CapturedType var1, S var2);

        public R visitForAll(ForAll var1, S var2);

        public R visitUndetVar(UndetVar var1, S var2);

        public R visitErrorType(ErrorType var1, S var2);

        public R visitType(Type var1, S var2);
    }

    public static class UnknownType
    extends Type {
        public UnknownType() {
            super(null, TypeMetadata.EMPTY);
        }

        @Override
        public UnknownType cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to an unknown type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.UNKNOWN;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitUnknown(this, p);
        }

        @Override
        public boolean isPartial() {
            return true;
        }
    }

    public static class ErrorType
    extends ClassType
    implements org.openjdk.javax.lang.model.type.ErrorType {
        private Type originalType = null;

        public ErrorType(Symbol.ClassSymbol classSymbol, Type type) {
            this(type, classSymbol);
            classSymbol.type = this;
            classSymbol.kind = Kinds.Kind.ERR;
            classSymbol.members_field = new Scope.ErrorScope(classSymbol);
        }

        public ErrorType(Type type, Symbol.TypeSymbol typeSymbol) {
            super(noType, org.openjdk.tools.javac.util.List.nil(), null);
            this.tsym = typeSymbol;
            this.originalType = type == null ? noType : type;
        }

        private ErrorType(Type type, Symbol.TypeSymbol typeSymbol, TypeMetadata typeMetadata) {
            super(noType, org.openjdk.tools.javac.util.List.nil(), null, typeMetadata);
            this.tsym = typeSymbol;
            this.originalType = type == null ? noType : type;
        }

        @Override
        public ErrorType cloneWithMetadata(TypeMetadata typeMetadata) {
            return new ErrorType(this.originalType, this.tsym, typeMetadata){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.ERROR;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        public ErrorType(Name name, Symbol.TypeSymbol typeSymbol, Type type) {
            this(new Symbol.ClassSymbol(0x40000009L, name, null, typeSymbol), type);
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitErrorType(this, s);
        }

        @Override
        public Type constType(Object object) {
            return this;
        }

        @Override
        public Type getEnclosingType() {
            return this;
        }

        @Override
        public Type getReturnType() {
            return this;
        }

        public Type asSub(Symbol symbol) {
            return this;
        }

        public boolean isGenType(Type type) {
            return true;
        }

        @Override
        public boolean isErroneous() {
            return true;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public boolean isInterface() {
            return false;
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> allparams() {
            return org.openjdk.tools.javac.util.List.nil();
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> getTypeArguments() {
            return org.openjdk.tools.javac.util.List.nil();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ERROR;
        }

        @Override
        public Type getOriginalType() {
            return this.originalType;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitError(this, p);
        }
    }

    static class BottomType
    extends Type
    implements NullType {
        public BottomType() {
            super(null, TypeMetadata.EMPTY);
        }

        @Override
        public BottomType cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to a bottom type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.BOT;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NULL;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNull(this, p);
        }

        @Override
        public Type constType(Object object) {
            return this;
        }

        @Override
        public String stringValue() {
            return "null";
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }
    }

    public static class JCVoidType
    extends Type
    implements NoType {
        public JCVoidType() {
            super(null, TypeMetadata.EMPTY);
        }

        @Override
        public JCVoidType cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to a void type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.VOID;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.VOID;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return true;
        }
    }

    public static class JCNoType
    extends Type
    implements NoType {
        public JCNoType() {
            super(null, TypeMetadata.EMPTY);
        }

        @Override
        public JCNoType cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to a JCNoType");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.NONE;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NONE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }

        @Override
        public boolean isCompound() {
            return false;
        }
    }

    public static class UndetVar
    extends DelegatedType {
        public ArrayDeque<Infer.IncorporationAction> incorporationActions = new ArrayDeque();
        protected Map<InferenceBound, org.openjdk.tools.javac.util.List<Type>> bounds;
        private Type inst = null;
        public int declaredCount;
        public UndetVarListener listener = null;
        Kind kind;
        Types.TypeMapping<Void> toTypeVarMap = new StructuralTypeMapping<Void>(){

            @Override
            public Type visitUndetVar(UndetVar undetVar, Void void_) {
                return undetVar.inst != null ? undetVar.inst : undetVar.qtype;
            }
        };

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitUndetVar(this, s);
        }

        public UndetVar(TypeVar typeVar, UndetVarListener undetVarListener, Types types) {
            super(TypeTag.UNDETVAR, typeVar);
            this.kind = typeVar.isCaptured() ? Kind.CAPTURED : Kind.NORMAL;
            this.listener = undetVarListener;
            this.bounds = new EnumMap<InferenceBound, org.openjdk.tools.javac.util.List<Type>>(InferenceBound.class);
            org.openjdk.tools.javac.util.List<Type> list = types.getBounds(typeVar);
            this.declaredCount = list.length();
            this.bounds.put(InferenceBound.UPPER, org.openjdk.tools.javac.util.List.nil());
            this.bounds.put(InferenceBound.LOWER, org.openjdk.tools.javac.util.List.nil());
            this.bounds.put(InferenceBound.EQ, org.openjdk.tools.javac.util.List.nil());
            for (Type type : list.reverse()) {
                this.addBound(InferenceBound.UPPER, type, types, true);
            }
            if (typeVar.isCaptured() && !typeVar.lower.hasTag(TypeTag.BOT)) {
                this.addBound(InferenceBound.LOWER, typeVar.lower, types, true);
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendAnnotationsString(stringBuilder);
            if (this.inst == null) {
                stringBuilder.append(this.qtype);
                stringBuilder.append('?');
            } else {
                stringBuilder.append(this.inst);
            }
            return stringBuilder.toString();
        }

        public String debugString() {
            String string = "inference var = " + this.qtype + "\n";
            if (this.inst != null) {
                string = string + "inst = " + this.inst + '\n';
            }
            for (InferenceBound inferenceBound : InferenceBound.values()) {
                org.openjdk.tools.javac.util.List<Type> list = this.bounds.get((Object)inferenceBound);
                if (list.size() <= 0) continue;
                string = string + (Object)((Object)inferenceBound) + " = " + list + '\n';
            }
            return string;
        }

        public void setThrow() {
            if (this.kind == Kind.CAPTURED) {
                throw new IllegalStateException();
            }
            this.kind = Kind.THROWS;
        }

        public UndetVar dup(Types types) {
            UndetVar undetVar = new UndetVar((TypeVar)this.qtype, this.listener, types);
            this.dupTo(undetVar, types);
            return undetVar;
        }

        public void dupTo(UndetVar undetVar, Types types) {
            undetVar.listener = null;
            undetVar.bounds.clear();
            for (InferenceBound inferenceBound : InferenceBound.values()) {
                undetVar.bounds.put(inferenceBound, org.openjdk.tools.javac.util.List.nil());
                for (Type type : this.getBounds(inferenceBound)) {
                    undetVar.addBound(inferenceBound, type, types, true);
                }
            }
            undetVar.inst = this.inst;
            undetVar.listener = this.listener;
            undetVar.incorporationActions = new ArrayDeque();
            for (Infer.IncorporationAction incorporationAction : this.incorporationActions) {
                undetVar.incorporationActions.add(incorporationAction.dup(undetVar));
            }
        }

        @Override
        public UndetVar cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to an UndetVar type");
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public Type baseType() {
            return this.inst == null ? this : this.inst.baseType();
        }

        public Type getInst() {
            return this.inst;
        }

        public void setInst(Type type) {
            this.inst = type;
            if (this.listener != null) {
                this.listener.varInstantiated(this);
            }
        }

        public org.openjdk.tools.javac.util.List<Type> getBounds(InferenceBound ... inferenceBoundArray) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (InferenceBound inferenceBound : inferenceBoundArray) {
                listBuffer.appendList(this.bounds.get((Object)inferenceBound));
            }
            return listBuffer.toList();
        }

        public org.openjdk.tools.javac.util.List<Type> getDeclaredBounds() {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            int n = 0;
            for (Type type : this.getBounds(InferenceBound.UPPER)) {
                if (n++ == this.declaredCount) break;
                listBuffer.append(type);
            }
            return listBuffer.toList();
        }

        public void setBounds(InferenceBound inferenceBound, org.openjdk.tools.javac.util.List<Type> list) {
            this.bounds.put(inferenceBound, list);
        }

        public final void addBound(InferenceBound inferenceBound, Type type, Types types) {
            if (types.mapCapturesToBounds) {
                switch (inferenceBound) {
                    case LOWER: {
                        type = types.cvarUpperBound(type);
                        break;
                    }
                    case UPPER: {
                        Type type2 = types.cvarLowerBound(type);
                        if (type2.hasTag(TypeTag.BOT)) break;
                        type = type2;
                    }
                }
            }
            this.addBound(inferenceBound, type, types, false);
        }

        private void addBound(InferenceBound inferenceBound, Type type, Types types, boolean bl) {
            if (this.kind == Kind.CAPTURED && !bl) {
                if (type.hasTag(TypeTag.UNDETVAR) && !((UndetVar)type).isCaptured()) {
                    ((UndetVar)type).addBound(inferenceBound.complement(), this, types, false);
                }
            } else {
                Type type2 = type.map(this.toTypeVarMap).baseType();
                org.openjdk.tools.javac.util.List<Type> list = this.bounds.get((Object)inferenceBound);
                if (type == this.qtype) {
                    return;
                }
                for (Type type3 : list) {
                    if (!types.isSameType(type3, type2, true)) continue;
                    return;
                }
                this.bounds.put(inferenceBound, list.prepend(type2));
                this.notifyBoundChange(inferenceBound, type2, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void substBounds(org.openjdk.tools.javac.util.List<Type> list, org.openjdk.tools.javac.util.List<Type> list2, Types types) {
            ListBuffer listBuffer = new ListBuffer();
            UndetVarListener undetVarListener = this.listener;
            try {
                this.listener = (undetVar, inferenceBound, type, bl) -> {
                    Assert.check(undetVar == this);
                    listBuffer.add(new Pair<InferenceBound, Type>(inferenceBound, type));
                };
                for (Map.Entry<InferenceBound, org.openjdk.tools.javac.util.List<Type>> object : this.bounds.entrySet()) {
                    InferenceBound inferenceBound2 = object.getKey();
                    org.openjdk.tools.javac.util.List<Type> list3 = object.getValue();
                    ListBuffer<Type> listBuffer2 = new ListBuffer<Type>();
                    ListBuffer<Type> listBuffer3 = new ListBuffer<Type>();
                    for (Type type2 : list3) {
                        if (!type2.containsAny(list)) {
                            listBuffer2.append(type2);
                            continue;
                        }
                        listBuffer3.append(type2);
                    }
                    this.bounds.put(inferenceBound2, listBuffer2.toList());
                    for (Type type2 : listBuffer3) {
                        this.addBound(inferenceBound2, types.subst(type2, list, list2), types, true);
                    }
                }
                this.listener = undetVarListener;
            }
            catch (Throwable throwable) {
                this.listener = undetVarListener;
                for (Pair pair : listBuffer) {
                    this.notifyBoundChange((InferenceBound)((Object)pair.fst), (Type)pair.snd, true);
                }
                throw throwable;
            }
            for (Pair pair : listBuffer) {
                this.notifyBoundChange((InferenceBound)((Object)pair.fst), (Type)pair.snd, true);
            }
        }

        private void notifyBoundChange(InferenceBound inferenceBound, Type type, boolean bl) {
            if (this.listener != null) {
                this.listener.varBoundChanged(this, inferenceBound, type, bl);
            }
        }

        public final boolean isCaptured() {
            return this.kind == Kind.CAPTURED;
        }

        public final boolean isThrows() {
            return this.kind == Kind.THROWS;
        }

        public static enum InferenceBound {
            LOWER{

                @Override
                public InferenceBound complement() {
                    return UPPER;
                }
            }
            ,
            EQ{

                @Override
                public InferenceBound complement() {
                    return EQ;
                }
            }
            ,
            UPPER{

                @Override
                public InferenceBound complement() {
                    return LOWER;
                }
            };


            public abstract InferenceBound complement();

            public boolean lessThan(InferenceBound inferenceBound) {
                if (inferenceBound == this) {
                    return false;
                }
                switch (inferenceBound) {
                    case UPPER: {
                        return true;
                    }
                    case LOWER: {
                        return false;
                    }
                    case EQ: {
                        return this != UPPER;
                    }
                }
                Assert.error("Cannot get here!");
                return false;
            }
        }

        public static interface UndetVarListener {
            public void varBoundChanged(UndetVar var1, InferenceBound var2, Type var3, boolean var4);

            default public void varInstantiated(UndetVar undetVar) {
                Assert.error();
            }
        }

        static enum Kind {
            NORMAL,
            CAPTURED,
            THROWS;

        }
    }

    public static class ForAll
    extends DelegatedType
    implements ExecutableType {
        public org.openjdk.tools.javac.util.List<Type> tvars;

        public ForAll(org.openjdk.tools.javac.util.List<Type> list, Type type) {
            super(TypeTag.FORALL, (MethodType)type);
            this.tvars = list;
        }

        @Override
        public ForAll cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to a forall type");
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitForAll(this, s);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendAnnotationsString(stringBuilder);
            stringBuilder.append('<');
            stringBuilder.append(this.tvars);
            stringBuilder.append('>');
            stringBuilder.append(this.qtype);
            return stringBuilder.toString();
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> getTypeArguments() {
            return this.tvars;
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }

        @Override
        public boolean contains(Type type) {
            return this.qtype.contains(type);
        }

        @Override
        public MethodType asMethodType() {
            return (MethodType)this.qtype;
        }

        @Override
        public void complete() {
            org.openjdk.tools.javac.util.List<Type> list = this.tvars;
            while (list.nonEmpty()) {
                ((TypeVar)list.head).bound.complete();
                list = list.tail;
            }
            this.qtype.complete();
        }

        public org.openjdk.tools.javac.util.List<TypeVar> getTypeVariables() {
            return org.openjdk.tools.javac.util.List.convert(TypeVar.class, this.getTypeArguments());
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitExecutable(this, p);
        }
    }

    public static abstract class DelegatedType
    extends Type {
        public Type qtype;
        public TypeTag tag;

        public DelegatedType(TypeTag typeTag, Type type) {
            this(typeTag, type, TypeMetadata.EMPTY);
        }

        public DelegatedType(TypeTag typeTag, Type type, TypeMetadata typeMetadata) {
            super(type.tsym, typeMetadata);
            this.tag = typeTag;
            this.qtype = type;
        }

        @Override
        public TypeTag getTag() {
            return this.tag;
        }

        @Override
        public String toString() {
            return this.qtype.toString();
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> getTypeArguments() {
            return this.qtype.getTypeArguments();
        }

        @Override
        public Type getEnclosingType() {
            return this.qtype.getEnclosingType();
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> getParameterTypes() {
            return this.qtype.getParameterTypes();
        }

        @Override
        public Type getReturnType() {
            return this.qtype.getReturnType();
        }

        @Override
        public Type getReceiverType() {
            return this.qtype.getReceiverType();
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> getThrownTypes() {
            return this.qtype.getThrownTypes();
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> allparams() {
            return this.qtype.allparams();
        }

        @Override
        public Type getUpperBound() {
            return this.qtype.getUpperBound();
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }
    }

    public static class CapturedType
    extends TypeVar {
        public WildcardType wildcard;

        public CapturedType(Name name, Symbol symbol, Type type, Type type2, WildcardType wildcardType) {
            super(name, symbol, type2);
            this.lower = Assert.checkNonNull(type2);
            this.bound = type;
            this.wildcard = wildcardType;
        }

        public CapturedType(Symbol.TypeSymbol typeSymbol, Type type, Type type2, Type type3, WildcardType wildcardType, TypeMetadata typeMetadata) {
            super(typeSymbol, type, type3, typeMetadata);
            this.wildcard = wildcardType;
        }

        @Override
        public CapturedType cloneWithMetadata(TypeMetadata typeMetadata) {
            return new CapturedType(this.tsym, this.bound, this.bound, this.lower, this.wildcard, typeMetadata){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitCapturedType(this, s);
        }

        @Override
        public boolean isCaptured() {
            return true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendAnnotationsString(stringBuilder);
            stringBuilder.append("capture#");
            stringBuilder.append(((long)this.hashCode() & 0xFFFFFFFFL) % 997L);
            stringBuilder.append(" of ");
            stringBuilder.append(this.wildcard);
            return stringBuilder.toString();
        }
    }

    public static class TypeVar
    extends Type
    implements TypeVariable {
        public Type bound = null;
        public Type lower;
        int rank_field = -1;

        public TypeVar(Name name, Symbol symbol, Type type) {
            super(null, TypeMetadata.EMPTY);
            this.tsym = new Symbol.TypeVariableSymbol(0L, name, this, symbol);
            this.bound = null;
            this.lower = type;
        }

        public TypeVar(Symbol.TypeSymbol typeSymbol, Type type, Type type2) {
            this(typeSymbol, type, type2, TypeMetadata.EMPTY);
        }

        public TypeVar(Symbol.TypeSymbol typeSymbol, Type type, Type type2, TypeMetadata typeMetadata) {
            super(typeSymbol, typeMetadata);
            this.bound = type;
            this.lower = type2;
        }

        @Override
        public TypeVar cloneWithMetadata(TypeMetadata typeMetadata) {
            return new TypeVar(this.tsym, this.bound, this.lower, typeMetadata){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.TYPEVAR;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitTypeVar(this, s);
        }

        @Override
        public Type getUpperBound() {
            if ((this.bound == null || this.bound.hasTag(TypeTag.NONE)) && this != this.tsym.type) {
                this.bound = this.tsym.type.getUpperBound();
            }
            return this.bound;
        }

        @Override
        public Type getLowerBound() {
            return this.lower;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.TYPEVAR;
        }

        public boolean isCaptured() {
            return false;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitTypeVariable(this, p);
        }
    }

    public static class ModuleType
    extends Type
    implements NoType {
        ModuleType(Symbol.ModuleSymbol moduleSymbol) {
            super(moduleSymbol, TypeMetadata.EMPTY);
        }

        @Override
        public ModuleType cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to a module type");
        }

        @Override
        public ModuleType annotatedType(org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list) {
            throw new AssertionError((Object)"Cannot annotate a module type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.MODULE;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitModuleType(this, s);
        }

        @Override
        public String toString() {
            return this.tsym.getQualifiedName().toString();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.MODULE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }
    }

    public static class PackageType
    extends Type
    implements NoType {
        PackageType(Symbol.PackageSymbol packageSymbol) {
            super(packageSymbol, TypeMetadata.EMPTY);
        }

        @Override
        public PackageType cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to a package type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.PACKAGE;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitPackageType(this, s);
        }

        @Override
        public String toString() {
            return this.tsym.getQualifiedName().toString();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.PACKAGE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }
    }

    public static class MethodType
    extends Type
    implements ExecutableType {
        public org.openjdk.tools.javac.util.List<Type> argtypes;
        public Type restype;
        public org.openjdk.tools.javac.util.List<Type> thrown;
        public Type recvtype;

        public MethodType(org.openjdk.tools.javac.util.List<Type> list, Type type, org.openjdk.tools.javac.util.List<Type> list2, Symbol.TypeSymbol typeSymbol) {
            super(typeSymbol, TypeMetadata.EMPTY);
            this.argtypes = list;
            this.restype = type;
            this.thrown = list2;
        }

        @Override
        public MethodType cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to a method type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.METHOD;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitMethodType(this, s);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendAnnotationsString(stringBuilder);
            stringBuilder.append('(');
            stringBuilder.append(this.argtypes);
            stringBuilder.append(')');
            stringBuilder.append(this.restype);
            return stringBuilder.toString();
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> getParameterTypes() {
            return this.argtypes;
        }

        @Override
        public Type getReturnType() {
            return this.restype;
        }

        @Override
        public Type getReceiverType() {
            return this.recvtype;
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> getThrownTypes() {
            return this.thrown;
        }

        @Override
        public boolean isErroneous() {
            return MethodType.isErroneous(this.argtypes) || this.restype != null && this.restype.isErroneous();
        }

        @Override
        public boolean contains(Type type) {
            return type.equalsIgnoreMetadata(this) || MethodType.contains(this.argtypes, type) || this.restype.contains(type) || MethodType.contains(this.thrown, type);
        }

        @Override
        public MethodType asMethodType() {
            return this;
        }

        @Override
        public void complete() {
            org.openjdk.tools.javac.util.List<Type> list = this.argtypes;
            while (list.nonEmpty()) {
                ((Type)list.head).complete();
                list = list.tail;
            }
            this.restype.complete();
            this.recvtype.complete();
            list = this.thrown;
            while (list.nonEmpty()) {
                ((Type)list.head).complete();
                list = list.tail;
            }
        }

        public org.openjdk.tools.javac.util.List<TypeVar> getTypeVariables() {
            return org.openjdk.tools.javac.util.List.nil();
        }

        @Override
        public Symbol.TypeSymbol asElement() {
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitExecutable(this, p);
        }
    }

    public static class ArrayType
    extends Type
    implements org.openjdk.javax.lang.model.type.ArrayType {
        public Type elemtype;

        public ArrayType(Type type, Symbol.TypeSymbol typeSymbol) {
            this(type, typeSymbol, TypeMetadata.EMPTY);
        }

        public ArrayType(Type type, Symbol.TypeSymbol typeSymbol, TypeMetadata typeMetadata) {
            super(typeSymbol, typeMetadata);
            this.elemtype = type;
        }

        public ArrayType(ArrayType arrayType) {
            this(arrayType.elemtype, arrayType.tsym, arrayType.getMetadata());
        }

        @Override
        public ArrayType cloneWithMetadata(TypeMetadata typeMetadata) {
            return new ArrayType(this.elemtype, this.tsym, typeMetadata){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.ARRAY;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitArrayType(this, s);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Type type = this.elemtype;
            while (type.getKind() == TypeKind.ARRAY) {
                type = ((ArrayType)type).getComponentType();
            }
            stringBuilder.append(type);
            type = this;
            do {
                type.appendAnnotationsString(stringBuilder, true);
                stringBuilder.append("[]");
            } while ((type = ((ArrayType)type).getComponentType()).getKind() == TypeKind.ARRAY);
            return stringBuilder.toString();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)object;
                return this == arrayType || this.elemtype.equals(arrayType.elemtype);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (TypeTag.ARRAY.ordinal() << 5) + this.elemtype.hashCode();
        }

        public boolean isVarargs() {
            return false;
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> allparams() {
            return this.elemtype.allparams();
        }

        @Override
        public boolean isErroneous() {
            return this.elemtype.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.elemtype.isParameterized();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public boolean isRaw() {
            return this.elemtype.isRaw();
        }

        public ArrayType makeVarargs() {
            return new ArrayType(this.elemtype, this.tsym, this.metadata){

                @Override
                public boolean isVarargs() {
                    return true;
                }
            };
        }

        @Override
        public boolean contains(Type type) {
            return type.equalsIgnoreMetadata(this) || this.elemtype.contains(type);
        }

        @Override
        public void complete() {
            this.elemtype.complete();
        }

        @Override
        public Type getComponentType() {
            return this.elemtype;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ARRAY;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitArray(this, p);
        }
    }

    public static class IntersectionClassType
    extends ClassType
    implements IntersectionType {
        public boolean allInterfaces;

        public IntersectionClassType(org.openjdk.tools.javac.util.List<Type> list, Symbol.ClassSymbol classSymbol, boolean bl) {
            super(noType, org.openjdk.tools.javac.util.List.nil(), classSymbol);
            this.allInterfaces = bl;
            Assert.check((classSymbol.flags() & 0x1000000L) != 0L);
            this.supertype_field = (Type)list.head;
            this.interfaces_field = list.tail;
            Assert.check(!this.supertype_field.tsym.isCompleted() || !this.supertype_field.isInterface(), this.supertype_field);
        }

        @Override
        public IntersectionClassType cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to an intersection type");
        }

        @Override
        public List<? extends TypeMirror> getBounds() {
            return Collections.unmodifiableList(this.getExplicitComponents());
        }

        @Override
        public boolean isCompound() {
            return true;
        }

        public org.openjdk.tools.javac.util.List<Type> getComponents() {
            return this.interfaces_field.prepend(this.supertype_field);
        }

        @Override
        public boolean isIntersection() {
            return true;
        }

        public org.openjdk.tools.javac.util.List<Type> getExplicitComponents() {
            return this.allInterfaces ? this.interfaces_field : this.getComponents();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.INTERSECTION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitIntersection(this, p);
        }
    }

    public static class UnionClassType
    extends ClassType
    implements UnionType {
        final org.openjdk.tools.javac.util.List<? extends Type> alternatives_field;

        public UnionClassType(ClassType classType, org.openjdk.tools.javac.util.List<? extends Type> list) {
            super(classType.outer_field, classType.typarams_field, classType.tsym);
            this.allparams_field = classType.allparams_field;
            this.supertype_field = classType.supertype_field;
            this.interfaces_field = classType.interfaces_field;
            this.all_interfaces_field = classType.interfaces_field;
            this.alternatives_field = list;
        }

        @Override
        public UnionClassType cloneWithMetadata(TypeMetadata typeMetadata) {
            throw new AssertionError((Object)"Cannot add metadata to a union type");
        }

        public Type getLub() {
            return this.tsym.type;
        }

        @Override
        public List<? extends TypeMirror> getAlternatives() {
            return Collections.unmodifiableList(this.alternatives_field);
        }

        @Override
        public boolean isUnion() {
            return true;
        }

        @Override
        public boolean isCompound() {
            return this.getLub().isCompound();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.UNION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitUnion(this, p);
        }

        public Iterable<? extends Type> getAlternativeTypes() {
            return this.alternatives_field;
        }
    }

    public static class ErasedClassType
    extends ClassType {
        public ErasedClassType(Type type, Symbol.TypeSymbol typeSymbol, TypeMetadata typeMetadata) {
            super(type, org.openjdk.tools.javac.util.List.nil(), typeSymbol, typeMetadata);
        }

        @Override
        public boolean hasErasedSupertypes() {
            return true;
        }
    }

    public static class ClassType
    extends Type
    implements DeclaredType {
        private Type outer_field;
        public org.openjdk.tools.javac.util.List<Type> typarams_field;
        public org.openjdk.tools.javac.util.List<Type> allparams_field;
        public Type supertype_field;
        public org.openjdk.tools.javac.util.List<Type> interfaces_field;
        public org.openjdk.tools.javac.util.List<Type> all_interfaces_field;
        int rank_field = -1;

        public ClassType(Type type, org.openjdk.tools.javac.util.List<Type> list, Symbol.TypeSymbol typeSymbol) {
            this(type, list, typeSymbol, TypeMetadata.EMPTY);
        }

        public ClassType(Type type, org.openjdk.tools.javac.util.List<Type> list, Symbol.TypeSymbol typeSymbol, TypeMetadata typeMetadata) {
            super(typeSymbol, typeMetadata);
            this.outer_field = type;
            this.typarams_field = list;
            this.allparams_field = null;
            this.supertype_field = null;
            this.interfaces_field = null;
        }

        @Override
        public ClassType cloneWithMetadata(TypeMetadata typeMetadata) {
            return new ClassType(this.outer_field, this.typarams_field, this.tsym, typeMetadata){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.CLASS;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitClassType(this, s);
        }

        @Override
        public Type constType(Object object) {
            final Object object2 = object;
            return new ClassType(this.getEnclosingType(), this.typarams_field, this.tsym, this.metadata){

                @Override
                public Object constValue() {
                    return object2;
                }

                @Override
                public Type baseType() {
                    return this.tsym.type;
                }
            };
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getEnclosingType().hasTag(TypeTag.CLASS) && this.tsym.owner.kind == Kinds.Kind.TYP) {
                stringBuilder.append(this.getEnclosingType().toString());
                stringBuilder.append(".");
                this.appendAnnotationsString(stringBuilder);
                stringBuilder.append(this.className(this.tsym, false));
            } else {
                this.appendAnnotationsString(stringBuilder);
                stringBuilder.append(this.className(this.tsym, true));
            }
            if (((org.openjdk.tools.javac.util.List)this.getTypeArguments()).nonEmpty()) {
                stringBuilder.append('<');
                stringBuilder.append(((org.openjdk.tools.javac.util.List)this.getTypeArguments()).toString());
                stringBuilder.append(">");
            }
            return stringBuilder.toString();
        }

        private String className(Symbol symbol, boolean bl) {
            if (symbol.name.isEmpty() && (symbol.flags() & 0x1000000L) != 0L) {
                StringBuilder stringBuilder = new StringBuilder(this.supertype_field.toString());
                org.openjdk.tools.javac.util.List<Type> list = this.interfaces_field;
                while (list.nonEmpty()) {
                    stringBuilder.append("&");
                    stringBuilder.append(((Type)list.head).toString());
                    list = list.tail;
                }
                return stringBuilder.toString();
            }
            if (symbol.name.isEmpty()) {
                ClassType classType = (ClassType)this.tsym.type;
                String string = classType == null ? Log.getLocalizedString("anonymous.class", new Object[]{null}) : (classType.interfaces_field != null && classType.interfaces_field.nonEmpty() ? Log.getLocalizedString("anonymous.class", classType.interfaces_field.head) : Log.getLocalizedString("anonymous.class", classType.supertype_field));
                if (moreInfo) {
                    string = string + String.valueOf(symbol.hashCode());
                }
                return string;
            }
            if (bl) {
                return symbol.getQualifiedName().toString();
            }
            return symbol.name.toString();
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> getTypeArguments() {
            if (this.typarams_field == null) {
                this.complete();
                if (this.typarams_field == null) {
                    this.typarams_field = org.openjdk.tools.javac.util.List.nil();
                }
            }
            return this.typarams_field;
        }

        public boolean hasErasedSupertypes() {
            return this.isRaw();
        }

        @Override
        public Type getEnclosingType() {
            return this.outer_field;
        }

        public void setEnclosingType(Type type) {
            this.outer_field = type;
        }

        @Override
        public org.openjdk.tools.javac.util.List<Type> allparams() {
            if (this.allparams_field == null) {
                this.allparams_field = ((org.openjdk.tools.javac.util.List)this.getTypeArguments()).prependList(this.getEnclosingType().allparams());
            }
            return this.allparams_field;
        }

        @Override
        public boolean isErroneous() {
            return this.getEnclosingType().isErroneous() || ClassType.isErroneous((org.openjdk.tools.javac.util.List<Type>)this.getTypeArguments()) || this != this.tsym.type && this.tsym.type.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.allparams().tail != null;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public boolean isRaw() {
            return this != this.tsym.type && this.tsym.type.allparams().nonEmpty() && this.allparams().isEmpty();
        }

        @Override
        public boolean contains(Type type) {
            return type.equalsIgnoreMetadata(this) || this.isParameterized() && (this.getEnclosingType().contains(type) || ClassType.contains((org.openjdk.tools.javac.util.List<Type>)this.getTypeArguments(), type)) || this.isCompound() && (this.supertype_field.contains(type) || ClassType.contains(this.interfaces_field, type));
        }

        @Override
        public void complete() {
            this.tsym.complete();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.DECLARED;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitDeclared(this, p);
        }
    }

    public static class WildcardType
    extends Type
    implements org.openjdk.javax.lang.model.type.WildcardType {
        public Type type;
        public BoundKind kind;
        public TypeVar bound;
        boolean isPrintingBound = false;

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitWildcardType(this, s);
        }

        public WildcardType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol) {
            this(type, boundKind, typeSymbol, null, TypeMetadata.EMPTY);
        }

        public WildcardType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol, TypeMetadata typeMetadata) {
            this(type, boundKind, typeSymbol, null, typeMetadata);
        }

        public WildcardType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol, TypeVar typeVar) {
            this(type, boundKind, typeSymbol, typeVar, TypeMetadata.EMPTY);
        }

        public WildcardType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol, TypeVar typeVar, TypeMetadata typeMetadata) {
            super(typeSymbol, typeMetadata);
            this.type = Assert.checkNonNull(type);
            this.kind = boundKind;
            this.bound = typeVar;
        }

        @Override
        public WildcardType cloneWithMetadata(TypeMetadata typeMetadata) {
            return new WildcardType(this.type, this.kind, this.tsym, this.bound, typeMetadata){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.WILDCARD;
        }

        @Override
        public boolean contains(Type type) {
            return this.kind != BoundKind.UNBOUND && this.type.contains(type);
        }

        @Override
        public boolean isSuperBound() {
            return this.kind == BoundKind.SUPER || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isExtendsBound() {
            return this.kind == BoundKind.EXTENDS || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isUnbound() {
            return this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public Type withTypeVar(Type type) {
            if (this.bound == type) {
                return this;
            }
            this.bound = (TypeVar)type;
            return this;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendAnnotationsString(stringBuilder);
            stringBuilder.append(this.kind.toString());
            if (this.kind != BoundKind.UNBOUND) {
                stringBuilder.append(this.type);
            }
            if (moreInfo && this.bound != null && !this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    stringBuilder.append("{:").append(this.bound.bound).append(":}");
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public Type getExtendsBound() {
            if (this.kind == BoundKind.EXTENDS) {
                return this.type;
            }
            return null;
        }

        @Override
        public Type getSuperBound() {
            if (this.kind == BoundKind.SUPER) {
                return this.type;
            }
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.WILDCARD;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitWildcard(this, p);
        }
    }

    public static class JCPrimitiveType
    extends Type
    implements PrimitiveType {
        TypeTag tag;

        public JCPrimitiveType(TypeTag typeTag, Symbol.TypeSymbol typeSymbol) {
            this(typeTag, typeSymbol, TypeMetadata.EMPTY);
        }

        private JCPrimitiveType(TypeTag typeTag, Symbol.TypeSymbol typeSymbol, TypeMetadata typeMetadata) {
            super(typeSymbol, typeMetadata);
            this.tag = typeTag;
            Assert.check(typeTag.isPrimitive);
        }

        @Override
        public JCPrimitiveType cloneWithMetadata(TypeMetadata typeMetadata) {
            return new JCPrimitiveType(this.tag, this.tsym, typeMetadata){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public boolean isNumeric() {
            return this.tag != TypeTag.BOOLEAN;
        }

        @Override
        public boolean isIntegral() {
            switch (this.tag) {
                case CHAR: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public TypeTag getTag() {
            return this.tag;
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return true;
        }

        @Override
        public Type constType(Object object) {
            final Object object2 = object;
            return new JCPrimitiveType(this.tag, this.tsym, this.metadata){

                @Override
                public Object constValue() {
                    return object2;
                }

                @Override
                public Type baseType() {
                    return this.tsym.type;
                }
            };
        }

        @Override
        public String stringValue() {
            Object object = Assert.checkNonNull(this.constValue());
            if (this.tag == TypeTag.BOOLEAN) {
                return (Integer)object == 0 ? "false" : "true";
            }
            if (this.tag == TypeTag.CHAR) {
                return String.valueOf((char)((Integer)object).intValue());
            }
            return object.toString();
        }

        @Override
        public boolean isFalse() {
            return this.tag == TypeTag.BOOLEAN && this.constValue() != null && (Integer)this.constValue() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.tag == TypeTag.BOOLEAN && this.constValue() != null && (Integer)this.constValue() != 0;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitPrimitive(this, p);
        }

        @Override
        public TypeKind getKind() {
            switch (this.tag) {
                case BYTE: {
                    return TypeKind.BYTE;
                }
                case CHAR: {
                    return TypeKind.CHAR;
                }
                case SHORT: {
                    return TypeKind.SHORT;
                }
                case INT: {
                    return TypeKind.INT;
                }
                case LONG: {
                    return TypeKind.LONG;
                }
                case FLOAT: {
                    return TypeKind.FLOAT;
                }
                case DOUBLE: {
                    return TypeKind.DOUBLE;
                }
                case BOOLEAN: {
                    return TypeKind.BOOLEAN;
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class StructuralTypeMapping<S>
    extends Types.TypeMapping<S> {
        @Override
        public Type visitClassType(ClassType classType, S s) {
            Type type = classType.getEnclosingType();
            Type type2 = (Type)this.visit(type, s);
            List list = classType.getTypeArguments();
            org.openjdk.tools.javac.util.List<Type> list2 = this.visit((org.openjdk.tools.javac.util.List<Type>)list, s);
            if (type2 == type && list2 == list) {
                return classType;
            }
            return new ClassType(type2, list2, classType.tsym, classType.metadata){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitWildcardType(WildcardType wildcardType, S s) {
            Type type = wildcardType.type;
            if (type != null) {
                type = (Type)this.visit(type, s);
            }
            if (type == wildcardType.type) {
                return wildcardType;
            }
            return new WildcardType(type, wildcardType.kind, wildcardType.tsym, wildcardType.bound, wildcardType.metadata){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitArrayType(ArrayType arrayType, S s) {
            Type type = arrayType.elemtype;
            Type type2 = (Type)this.visit(type, s);
            if (type2 == type) {
                return arrayType;
            }
            return new ArrayType(type2, arrayType.tsym, arrayType.metadata){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitMethodType(MethodType methodType, S s) {
            org.openjdk.tools.javac.util.List<Type> list = methodType.argtypes;
            Type type = methodType.restype;
            org.openjdk.tools.javac.util.List<Type> list2 = methodType.thrown;
            org.openjdk.tools.javac.util.List<Type> list3 = this.visit(list, s);
            Type type2 = (Type)this.visit(type, s);
            org.openjdk.tools.javac.util.List<Type> list4 = this.visit(list2, s);
            if (list3 == list && type2 == type && list4 == list2) {
                return methodType;
            }
            return new MethodType(list3, type2, list4, methodType.tsym){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitForAll(ForAll forAll, S s) {
            return (Type)this.visit(forAll.qtype, s);
        }
    }
}

