/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBrooklynObjectSpec<T, SpecT extends AbstractBrooklynObjectSpec<T, SpecT>>
implements Serializable {
    private static final long serialVersionUID = 3010955277740333030L;
    private static final Logger log = LoggerFactory.getLogger(AbstractBrooklynObjectSpec.class);
    private final Class<? extends T> type;
    private String displayName;
    private String catalogItemId;
    private Collection<String> catalogItemIdSearchPath = MutableSet.of();
    private Set<Object> tags = MutableSet.of();
    private List<SpecParameter<?>> parameters = ImmutableList.of();
    protected final Map<String, Object> flags = Maps.newLinkedHashMap();
    protected final Map<ConfigKey<?>, Object> config = Maps.newLinkedHashMap();

    protected AbstractBrooklynObjectSpec(Class<? extends T> type) {
        this.checkValidType(type);
        this.type = type;
    }

    protected SpecT self() {
        return (SpecT)this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", this.type).add("displayName", (Object)this.displayName).toString();
    }

    protected abstract void checkValidType(Class<? extends T> var1);

    public SpecT displayName(String val) {
        this.displayName = val;
        return this.self();
    }

    public SpecT catalogItemId(String val) {
        this.catalogItemId = val;
        return this.self();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SpecT catalogItemIdAndSearchPath(String catalogItemId, Collection<String> searchPath) {
        if (catalogItemId != null) {
            this.catalogItemId(catalogItemId);
            Collection<String> collection = this.catalogItemIdSearchPath;
            synchronized (collection) {
                this.catalogItemIdSearchPath.clear();
                if (searchPath != null) {
                    this.catalogItemIdSearchPath.addAll(searchPath);
                }
            }
        }
        return this.self();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SpecT addSearchPath(List<String> searchPath) {
        if (searchPath != null) {
            Collection<String> collection = this.catalogItemIdSearchPath;
            synchronized (collection) {
                this.catalogItemIdSearchPath.addAll(searchPath);
            }
        }
        return this.self();
    }

    @Deprecated
    @Beta
    public SpecT catalogItemIdIfNotNull(String val) {
        if (val != null) {
            this.catalogItemId(val);
        }
        return this.self();
    }

    protected Object readResolve() {
        if (this.catalogItemIdSearchPath == null) {
            this.catalogItemIdSearchPath = MutableList.of();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public SpecT stackCatalogItemId(String val) {
        if (null != val) {
            if (null != this.catalogItemId && !this.catalogItemId.equals(val)) {
                Collection<String> collection = this.catalogItemIdSearchPath;
                synchronized (collection) {
                    MutableSet newPath = MutableSet.of();
                    newPath.add(this.catalogItemId);
                    newPath.addAll(this.catalogItemIdSearchPath);
                    this.catalogItemIdSearchPath.clear();
                    this.catalogItemIdSearchPath.addAll((Collection<String>)newPath);
                }
            }
            this.catalogItemId(val);
        }
        return this.self();
    }

    public SpecT tag(Object tag) {
        this.tags.add(tag);
        return this.self();
    }

    public SpecT tags(Iterable<? extends Object> tagsToAdd) {
        return this.tagsAdd(tagsToAdd);
    }

    public SpecT tagsAdd(Iterable<? extends Object> tagsToAdd) {
        Iterables.addAll(this.tags, tagsToAdd);
        return this.self();
    }

    public SpecT tagsReplace(Iterable<? extends Object> tagsToReplace) {
        this.tags.clear();
        Iterables.addAll(this.tags, tagsToReplace);
        return this.self();
    }

    @Beta
    public SpecT parameters(Iterable<? extends SpecParameter<?>> parameters) {
        return this.parametersReplace(parameters);
    }

    @Beta
    public SpecT parametersAdd(Iterable<? extends SpecParameter<?>> parameters) {
        MutableSet params = MutableSet.copyOf(parameters);
        MutableSet current = MutableSet.copyOf(this.parameters);
        current.removeAll((Collection<?>)params);
        return this.parametersReplace((Iterable<? extends SpecParameter<?>>)ImmutableList.builder().addAll((Iterable)params).addAll((Iterable)current).build());
    }

    @Beta
    public SpecT parametersReplace(Iterable<? extends SpecParameter<?>> parameters) {
        this.parameters = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(parameters, (Object)"parameters")));
        return this.self();
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final String getCatalogItemId() {
        return this.catalogItemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getCatalogItemIdSearchPath() {
        Collection<String> collection = this.catalogItemIdSearchPath;
        synchronized (collection) {
            return ImmutableList.copyOf(this.catalogItemIdSearchPath);
        }
    }

    public final Set<Object> getTags() {
        return ImmutableSet.copyOf(this.tags);
    }

    public final List<SpecParameter<?>> getParameters() {
        if (this.parameters != null) {
            return ImmutableList.copyOf(this.parameters);
        }
        return ImmutableList.of();
    }

    protected final void checkIsNewStyleImplementation(Class<?> implClazz) {
        try {
            implClazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Implementation " + implClazz + " must have a no-argument constructor");
        }
        catch (SecurityException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (implClazz.isInterface()) {
            throw new IllegalStateException("Implementation " + implClazz + " is an interface, but must be a non-abstract class");
        }
        if (Modifier.isAbstract(implClazz.getModifiers())) {
            throw new IllegalStateException("Implementation " + implClazz + " is abstract, but must be a non-abstract class");
        }
    }

    protected final void checkIsImplementation(Class<?> val, Class<? super T> requiredInterface) {
        if (!requiredInterface.isAssignableFrom(val)) {
            throw new IllegalStateException("Implementation " + val + " does not implement " + requiredInterface.getName());
        }
        if (val.isInterface()) {
            throw new IllegalStateException("Implementation " + val + " is an interface, but must be a non-abstract class");
        }
        if (Modifier.isAbstract(val.getModifiers())) {
            throw new IllegalStateException("Implementation " + val + " is abstract, but must be a non-abstract class");
        }
    }

    protected SpecT copyFrom(SpecT otherSpec) {
        return ((AbstractBrooklynObjectSpec)((AbstractBrooklynObjectSpec)((AbstractBrooklynObjectSpec)((AbstractBrooklynObjectSpec)((AbstractBrooklynObjectSpec)this.displayName(((AbstractBrooklynObjectSpec)otherSpec).getDisplayName())).configure(((AbstractBrooklynObjectSpec)otherSpec).getConfig())).configure(((AbstractBrooklynObjectSpec)otherSpec).getFlags())).tags(((AbstractBrooklynObjectSpec)otherSpec).getTags())).catalogItemIdAndSearchPath(((AbstractBrooklynObjectSpec)otherSpec).getCatalogItemId(), ((AbstractBrooklynObjectSpec)otherSpec).getCatalogItemIdSearchPath())).parameters(((AbstractBrooklynObjectSpec)otherSpec).getParameters());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractBrooklynObjectSpec other = (AbstractBrooklynObjectSpec)obj;
        if (!Objects.equal((Object)this.getDisplayName(), (Object)other.getDisplayName())) {
            return false;
        }
        if (!Objects.equal((Object)this.getCatalogItemId(), (Object)other.getCatalogItemId())) {
            return false;
        }
        if (!Objects.equal(this.getCatalogItemIdSearchPath(), other.getCatalogItemIdSearchPath())) {
            return false;
        }
        if (!Objects.equal(this.getType(), other.getType())) {
            return false;
        }
        if (!Objects.equal(this.getTags(), other.getTags())) {
            return false;
        }
        if (!Objects.equal(this.getConfig(), other.getConfig())) {
            return false;
        }
        if (!Objects.equal(this.getFlags(), other.getFlags())) {
            return false;
        }
        return Objects.equal(this.getParameters(), other.getParameters());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getCatalogItemIdSearchPath(), this.getDisplayName(), this.getType(), this.getTags()});
    }

    public SpecT configure(Map<?, ?> val) {
        if (val == null) {
            log.warn("Null supplied when configuring " + this);
            log.debug("Source for null supplied when configuring " + this, new Throwable("Source for null supplied when configuring " + this));
            return this.self();
        }
        for (Map.Entry<?, ?> entry : val.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("Null key not permitted");
            }
            if (entry.getKey() instanceof CharSequence) {
                this.flags.put(entry.getKey().toString(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey) {
                this.config.put((ConfigKey)entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey.HasConfigKey) {
                this.config.put(((ConfigKey.HasConfigKey)entry.getKey()).getConfigKey(), entry.getValue());
                continue;
            }
            log.warn("Spec " + this + " ignoring unknown config key " + entry.getKey());
        }
        return this.self();
    }

    public SpecT configure(CharSequence key, Object val) {
        this.flags.put(((CharSequence)Preconditions.checkNotNull((Object)key, (Object)"key")).toString(), val);
        return this.self();
    }

    public <V> SpecT configure(ConfigKey<V> key, V val) {
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this.self();
    }

    public <V> SpecT configureIfNotNull(ConfigKey<V> key, V val) {
        return val != null ? this.configure(key, val) : this.self();
    }

    public <V> SpecT configure(ConfigKey<V> key, Task<? extends V> val) {
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this.self();
    }

    public <V> SpecT configure(ConfigKey.HasConfigKey<V> key, V val) {
        this.config.put(((ConfigKey.HasConfigKey)Preconditions.checkNotNull(key, (Object)"key")).getConfigKey(), val);
        return this.self();
    }

    public <V> SpecT configure(ConfigKey.HasConfigKey<V> key, Task<? extends V> val) {
        this.config.put(((ConfigKey.HasConfigKey)Preconditions.checkNotNull(key, (Object)"key")).getConfigKey(), val);
        return this.self();
    }

    public <V> SpecT removeConfig(ConfigKey<V> key) {
        this.config.remove(Preconditions.checkNotNull(key, (Object)"key"));
        return this.self();
    }

    public <V> SpecT removeFlag(String key) {
        this.flags.remove(Preconditions.checkNotNull((Object)key, (Object)"key"));
        return this.self();
    }

    public void clearConfig() {
        this.config.clear();
    }

    public Map<String, ?> getFlags() {
        return Collections.unmodifiableMap(this.flags);
    }

    public Map<ConfigKey<?>, Object> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }
}

