/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.util.core.json.BrooklynObjectsJsonMapper;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.commons.lang3.StringUtils;

public class ShellEnvironmentSerializer {
    private ObjectMapper mapper;

    public ShellEnvironmentSerializer(ManagementContext mgmt) {
        this.mapper = BrooklynObjectsJsonMapper.newMapper(mgmt);
    }

    public String serialize(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            String str = this.mapper.writeValueAsString(value);
            if (this.isJsonString(str)) {
                return value.toString();
            }
            return str;
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Map<String, String> serialize(@Nullable Map<?, ?> env) {
        if (env == null) {
            return null;
        }
        HashMap serializedEnv = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : env.entrySet()) {
            String key = this.serializeShellEnv(entry.getKey());
            String value = this.serializeShellEnv(entry.getValue());
            serializedEnv.put(key, value);
        }
        return serializedEnv;
    }

    protected boolean isJsonString(String str) {
        return str.length() > 0 && str.charAt(0) == '\"';
    }

    private String serializeShellEnv(Object value) {
        return StringUtils.defaultString((String)this.serialize(value));
    }
}

