/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.cache.tasks;

import java.util.List;
import java.util.Map;
import org.jclouds.karaf.cache.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCachesTask<T>
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateCachesTask.class);
    private final List<Cacheable<T>> cacheables;
    private final Map<String, T> services;
    private boolean keepRunning = true;

    public UpdateCachesTask(List<Cacheable<T>> cacheables, Map<String, T> services) {
        this.cacheables = cacheables;
        this.services = services;
    }

    @Override
    public void run() {
        if (this.services != null && !this.services.isEmpty()) {
            for (T service : this.services.values()) {
                if (this.cacheables == null || this.cacheables.isEmpty()) continue;
                for (Cacheable<T> cacheable : this.cacheables) {
                    try {
                        if (!this.keepRunning) continue;
                        cacheable.updateOnAdded(service);
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Error while updating cache:" + t.getMessage());
                    }
                }
            }
        }
    }

    public void stop() {
        this.keepRunning = false;
    }
}

