/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResourceQuotaSpecFluentImpl<A extends ResourceQuotaSpecFluent<A>>
extends BaseFluent<A>
implements ResourceQuotaSpecFluent<A> {
    private Map<String, Quantity> hard = new LinkedHashMap<String, Quantity>();
    private List<String> scopes = new ArrayList<String>();

    public ResourceQuotaSpecFluentImpl() {
    }

    public ResourceQuotaSpecFluentImpl(ResourceQuotaSpec instance) {
        this.withHard(instance.getHard());
        this.withScopes(instance.getScopes());
    }

    @Override
    public A addToHard(String key, Quantity value) {
        if (key != null && value != null) {
            this.hard.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToHard(Map<String, Quantity> map) {
        if (map != null) {
            this.hard.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromHard(String key) {
        if (key != null) {
            this.hard.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromHard(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.hard.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getHard() {
        return this.hard;
    }

    @Override
    public A withHard(Map<String, Quantity> hard) {
        this.hard.clear();
        if (hard != null) {
            this.hard.putAll(hard);
        }
        return (A)this;
    }

    @Override
    public A addToScopes(String ... items) {
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromScopes(String ... items) {
        for (String item : items) {
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public A withScopes(List<String> scopes) {
        this.scopes.clear();
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withScopes(String ... scopes) {
        this.scopes.clear();
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaSpecFluentImpl that = (ResourceQuotaSpecFluentImpl)o;
        if (this.hard != null ? !this.hard.equals(that.hard) : that.hard != null) {
            return false;
        }
        return !(this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null);
    }
}

