/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.compute;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.packet.PacketApi;
import org.jclouds.packet.compute.options.PacketTemplateOptions;
import org.jclouds.packet.domain.BillingCycle;
import org.jclouds.packet.domain.Device;
import org.jclouds.packet.domain.Facility;
import org.jclouds.packet.domain.OperatingSystem;
import org.jclouds.packet.domain.Plan;

@Singleton
public class PacketComputeServiceAdapter
implements ComputeServiceAdapter<Device, Plan, OperatingSystem, Facility> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final PacketApi api;
    private final String projectId;

    @Inject
    PacketComputeServiceAdapter(PacketApi api, @Provider Supplier<Credentials> creds) {
        this.api = api;
        this.projectId = ((Credentials)creds.get()).identity;
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<Device> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        PacketTemplateOptions templateOptions = (PacketTemplateOptions)template.getOptions().as(PacketTemplateOptions.class);
        Map<String, String> features = templateOptions.getFeatures();
        BillingCycle billingCycle = BillingCycle.fromValue(templateOptions.getBillingCycle());
        boolean locked = templateOptions.isLocked();
        String userdata = templateOptions.getUserData();
        Set tags = templateOptions.getTags();
        String plan = template.getHardware().getId();
        String facility = template.getLocation().getId();
        String operatingSystem = template.getImage().getId();
        Device device = this.api.deviceApi(this.projectId).create(Device.CreateDevice.builder().hostname(name).plan(plan).billingCycle(billingCycle.value()).facility(facility).features(features).operatingSystem(operatingSystem).locked(locked).userdata(userdata).tags(tags).build());
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)device, device.id(), null);
    }

    public Iterable<Plan> listHardwareProfiles() {
        return Iterables.filter((Iterable)this.api.planApi().list().concat(), (Predicate)new Predicate<Plan>(){

            public boolean apply(Plan input) {
                return input.line().equals("baremetal");
            }
        });
    }

    public Iterable<OperatingSystem> listImages() {
        return this.api.operatingSystemApi().list().concat();
    }

    public OperatingSystem getImage(final String id) {
        Optional firstInterestingOperatingSystem = this.api.operatingSystemApi().list().concat().firstMatch((Predicate)new Predicate<OperatingSystem>(){

            public boolean apply(OperatingSystem input) {
                return input.slug().equals(id);
            }
        });
        if (!firstInterestingOperatingSystem.isPresent()) {
            throw new IllegalStateException("Cannot find image with the required slug " + id);
        }
        return (OperatingSystem)firstInterestingOperatingSystem.get();
    }

    public Iterable<Facility> listLocations() {
        return this.api.facilityApi().list().concat();
    }

    public Device getNode(String id) {
        return this.api.deviceApi(this.projectId).get(id);
    }

    public void destroyNode(String id) {
        this.api.deviceApi(this.projectId).delete(id);
    }

    public void rebootNode(String id) {
        this.api.deviceApi(this.projectId).reboot(id);
    }

    public void resumeNode(String id) {
        this.api.deviceApi(this.projectId).powerOn(id);
    }

    public void suspendNode(String id) {
        this.api.deviceApi(this.projectId).powerOff(id);
    }

    public Iterable<Device> listNodes() {
        return this.api.deviceApi(this.projectId).list().concat();
    }

    public Iterable<Device> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<Device>(){

            public boolean apply(Device device) {
                return Iterables.contains((Iterable)ids, (Object)String.valueOf(device.id()));
            }
        });
    }
}

