/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest;

import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.ConfigPredicates;
import org.apache.brooklyn.rest.security.provider.ExplicitUsersSecurityProvider;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;

public class BrooklynWebConfig {
    public static final String BASE_NAME = "brooklyn.webconsole";
    public static final String BASE_NAME_SECURITY = "brooklyn.webconsole.security";
    public static final String REMOTE_ADDRESS_SESSION_ATTRIBUTE = "request.remoteAddress";
    public static final ConfigKey<String> SECURITY_PROVIDER_CLASSNAME = ConfigKeys.newStringConfigKey((String)"brooklyn.webconsole.security.provider", (String)"class name of a Brooklyn SecurityProvider", (String)ExplicitUsersSecurityProvider.class.getCanonicalName());
    public static final ConfigKey<SecurityProvider> SECURITY_PROVIDER_INSTANCE = ConfigKeys.newConfigKey(SecurityProvider.class, (String)(SECURITY_PROVIDER_CLASSNAME.getName() + ".internal.instance"), (String)"instance of a pre-configured security provider");
    public static final ConfigKey<String> SECURITY_PROVIDER_BUNDLE = ConfigKeys.newStringConfigKey((String)(SECURITY_PROVIDER_CLASSNAME.getName() + ".bundle.symbolicName"), (String)"Symbolic-name of the bundle containing the Brooklyn SecurityProvider");
    public static final ConfigKey<String> SECURITY_PROVIDER_BUNDLE_VERSION = ConfigKeys.newStringConfigKey((String)(SECURITY_PROVIDER_CLASSNAME.getName() + ".bundle.version"), (String)"Version of the bundle containing the Brooklyn SecurityProvider (optional)");
    public static final ConfigKey<String> USERS = ConfigKeys.newStringConfigKey((String)"brooklyn.webconsole.security.users");
    public static final ConfigKey<String> LDAP_URL = ConfigKeys.newStringConfigKey((String)"brooklyn.webconsole.security.ldap.url");
    public static final ConfigKey<String> LDAP_REALM = ConfigKeys.newStringConfigKey((String)"brooklyn.webconsole.security.ldap.realm");
    public static final ConfigKey<String> LDAP_OU = ConfigKeys.newStringConfigKey((String)"brooklyn.webconsole.security.ldap.ou");
    public static final ConfigKey<Boolean> HTTPS_REQUIRED = ConfigKeys.newBooleanConfigKey((String)"brooklyn.webconsole.security.https.required", (String)"Whether HTTPS is required; false here can be overridden by CLI option", (Boolean)false);
    public static final ConfigKey<PortRange> WEB_CONSOLE_PORT = ConfigKeys.newConfigKey(PortRange.class, (String)"brooklyn.webconsole.port", (String)"Port/range for the web console to listen on; can be overridden by CLI option");
    public static final ConfigKey<String> KEYSTORE_URL = ConfigKeys.newStringConfigKey((String)"brooklyn.webconsole.security.keystore.url", (String)"Keystore from which to take the certificate to present when running HTTPS; note that normally the password is also required, and an alias for the certificate if the keystore has more than one");
    public static final ConfigKey<String> KEYSTORE_PASSWORD = ConfigKeys.newStringConfigKey((String)"brooklyn.webconsole.security.keystore.password", (String)("Password for the " + KEYSTORE_URL));
    public static final ConfigKey<String> KEYSTORE_CERTIFICATE_ALIAS = ConfigKeys.newStringConfigKey((String)"brooklyn.webconsole.security.keystore.certificate.alias", (String)("Alias in " + KEYSTORE_URL + " for the certificate to use; defaults to the first if not supplied"));
    public static final ConfigKey<String> TRANSPORT_PROTOCOLS = ConfigKeys.newStringConfigKey((String)"brooklyn.webconsole.security.transport.protocols", (String)"SSL/TLS protocol versions to use for web console connections", (String)"TLSv1, TLSv1.1, TLSv1.2");
    public static final ConfigKey<String> TRANSPORT_CIPHERS = ConfigKeys.newStringConfigKey((String)"brooklyn.webconsole.security.transport.ciphers", (String)"SSL/TLS cipher suites to use for web console connections", (String)"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_DSS_WITH_AES_128_GCM_SHA256,TLS_DHE_DSS_WITH_AES_256_GCM_SHA384,TLS_DHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA256,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA256,TLS_DHE_RSA_WITH_AES_256_CBC_SHA256,TLS_DHE_DSS_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_RSA_WITH_AES_128_GCM_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384,TLS_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_CBC_SHA256,TLS_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA,TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA,TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA,TLS_SRP_SHA_WITH_AES_256_CBC_SHA,TLS_DHE_DSS_WITH_AES_256_CBC_SHA256,TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA,TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA,TLS_SRP_SHA_WITH_AES_128_CBC_SHA,TLS_DHE_DSS_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA,TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA,TLS_RSA_WITH_CAMELLIA_256_CBC_SHA,TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA,TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA,TLS_RSA_WITH_CAMELLIA_128_CBC_SHA,TLS_RSA_WITH_3DES_EDE_CBC_SHA,SSL_ECDHE_RSA_WITH_AES_128_GCM_SHA256,SSL_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,SSL_ECDHE_RSA_WITH_AES_256_GCM_SHA384,SSL_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,SSL_DHE_RSA_WITH_AES_128_GCM_SHA256,SSL_DHE_DSS_WITH_AES_128_GCM_SHA256,SSL_DHE_DSS_WITH_AES_256_GCM_SHA384,SSL_DHE_RSA_WITH_AES_256_GCM_SHA384,SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256,SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA,SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384,SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA,SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA,SSL_DHE_RSA_WITH_AES_128_CBC_SHA256,SSL_DHE_RSA_WITH_AES_128_CBC_SHA,SSL_DHE_DSS_WITH_AES_128_CBC_SHA256,SSL_DHE_RSA_WITH_AES_256_CBC_SHA256,SSL_DHE_DSS_WITH_AES_256_CBC_SHA,SSL_DHE_RSA_WITH_AES_256_CBC_SHA,SSL_RSA_WITH_AES_128_GCM_SHA256,SSL_RSA_WITH_AES_256_GCM_SHA384,SSL_RSA_WITH_AES_128_CBC_SHA256,SSL_RSA_WITH_AES_256_CBC_SHA256,SSL_RSA_WITH_AES_128_CBC_SHA,SSL_RSA_WITH_AES_256_CBC_SHA,SSL_SRP_SHA_DSS_WITH_AES_256_CBC_SHA,SSL_SRP_SHA_RSA_WITH_AES_256_CBC_SHA,SSL_SRP_SHA_WITH_AES_256_CBC_SHA,SSL_DHE_DSS_WITH_AES_256_CBC_SHA256,SSL_SRP_SHA_DSS_WITH_AES_128_CBC_SHA,SSL_SRP_SHA_RSA_WITH_AES_128_CBC_SHA,SSL_SRP_SHA_WITH_AES_128_CBC_SHA,SSL_DHE_DSS_WITH_AES_128_CBC_SHA,SSL_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA,SSL_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA,SSL_RSA_WITH_CAMELLIA_256_CBC_SHA,SSL_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA,SSL_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA,SSL_RSA_WITH_CAMELLIA_128_CBC_SHA,SSL_RSA_WITH_3DES_EDE_CBC_SHA");

    public static final ConfigKey<String> PASSWORD_FOR_USER(String user) {
        return ConfigKeys.newStringConfigKey((String)("brooklyn.webconsole.security.user." + user + ".password"));
    }

    public static final ConfigKey<String> SALT_FOR_USER(String user) {
        return ConfigKeys.newStringConfigKey((String)("brooklyn.webconsole.security.user." + user + ".salt"));
    }

    public static final ConfigKey<String> SHA256_FOR_USER(String user) {
        return ConfigKeys.newStringConfigKey((String)("brooklyn.webconsole.security.user." + user + ".sha256"));
    }

    public static final boolean hasNoSecurityOptions(ConfigMap config) {
        return config.findKeysPresent(ConfigPredicates.nameStartsWith((String)BASE_NAME_SECURITY)).isEmpty();
    }
}

