/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.inject.Singleton;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.ByteSourcePayload;

@Singleton
public class BasePayloadSlicer
implements PayloadSlicer {
    @Override
    public Payload slice(Payload input, long offset, long length) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset is negative");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length is negative");
        Payload returnVal = input.getRawContent() instanceof File ? this.doSlice((File)input.getRawContent(), offset, length) : (input.getRawContent() instanceof String ? this.doSlice((String)input.getRawContent(), offset, length) : (input.getRawContent() instanceof byte[] ? this.doSlice((byte[])input.getRawContent(), offset, length) : (input.getRawContent() instanceof InputStream ? this.doSlice((InputStream)input.getRawContent(), offset, length) : (input.getRawContent() instanceof ByteSource ? this.doSlice((ByteSource)input.getRawContent(), offset, length) : this.doSlice(input, offset, length)))));
        return this.copyMetadataAndSetLength(input, returnVal, length);
    }

    protected Payload doSlice(Payload content, long offset, long length) {
        return this.doSlice(content.getInput(), offset, length);
    }

    protected Payload doSlice(String content, long offset, long length) {
        return this.doSlice(content.getBytes(), offset, length);
    }

    protected Payload doSlice(File content, long offset, long length) {
        return this.doSlice(Files.asByteSource((File)content), offset, length);
    }

    protected Payload doSlice(InputStream content, long offset, long length) {
        try {
            ByteStreams.skipFully((InputStream)content, (long)offset);
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
        return Payloads.newInputStreamPayload(ByteStreams.limit((InputStream)content, (long)length));
    }

    protected Payload doSlice(ByteSource content, long offset, long length) {
        return Payloads.newByteSourcePayload(content.slice(offset, length));
    }

    protected Payload doSlice(byte[] content, long offset, long length) {
        Preconditions.checkArgument((offset <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"offset is too big for an array");
        Preconditions.checkArgument((length <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"length is too big for an array");
        return Payloads.newByteSourcePayload(ByteSource.wrap((byte[])content).slice(offset, length));
    }

    protected Payload copyMetadataAndSetLength(Payload input, Payload returnVal, long length) {
        returnVal.setContentMetadata(BaseMutableContentMetadata.fromContentMetadata(input.getContentMetadata().toBuilder().contentLength(length).contentMD5((HashCode)null).build()));
        return returnVal;
    }

    @Override
    public Iterable<Payload> slice(Payload input, long size) {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (String)"size must be non-negative but was: %s", (Object[])new Object[]{size});
        ContentMetadata meta = BaseMutableContentMetadata.fromContentMetadata(input.getContentMetadata()).toBuilder().contentLength(size).contentMD5((HashCode)null).build();
        Object rawContent = input.getRawContent();
        if (rawContent instanceof File) {
            return this.doSlice((File)rawContent, meta);
        }
        if (rawContent instanceof String) {
            return this.doSlice((String)rawContent, meta);
        }
        if (rawContent instanceof byte[]) {
            return this.doSlice((byte[])rawContent, meta);
        }
        if (rawContent instanceof InputStream) {
            return this.doSlice((InputStream)rawContent, meta);
        }
        if (rawContent instanceof ByteSource) {
            return this.doSlice((ByteSource)rawContent, meta);
        }
        return this.doSlice(input, meta);
    }

    protected Iterable<Payload> doSlice(Payload input, ContentMetadata meta) {
        return this.doSlice(input.getInput(), meta);
    }

    protected Iterable<Payload> doSlice(String rawContent, ContentMetadata meta) {
        return this.doSlice(ByteSource.wrap((byte[])rawContent.getBytes(Charsets.UTF_8)), meta);
    }

    protected Iterable<Payload> doSlice(byte[] rawContent, ContentMetadata meta) {
        return this.doSlice(ByteSource.wrap((byte[])rawContent), meta);
    }

    protected Iterable<Payload> doSlice(File rawContent, ContentMetadata meta) {
        return this.doSlice(Files.asByteSource((File)rawContent), meta);
    }

    protected Iterable<Payload> doSlice(InputStream rawContent, ContentMetadata meta) {
        return new InputStreamPayloadIterable(rawContent, meta);
    }

    protected Iterable<Payload> doSlice(ByteSource rawContent, ContentMetadata meta) {
        return new ByteSourcePayloadIterable(rawContent, meta);
    }

    private static final class ByteSourcePayloadIterator
    implements Iterator<Payload> {
        private final ByteSource input;
        private final ContentMetadata metaData;
        private Payload nextPayload;
        private long offset = 0L;
        private final long readLen;

        ByteSourcePayloadIterator(ByteSource input, ContentMetadata metaData) {
            this.input = (ByteSource)Preconditions.checkNotNull((Object)input, (Object)"input");
            this.metaData = (ContentMetadata)Preconditions.checkNotNull((Object)metaData, (Object)"metaData");
            this.readLen = (Long)Preconditions.checkNotNull((Object)this.metaData.getContentLength(), (Object)"content-length");
            this.nextPayload = this.getNextPayload();
        }

        @Override
        public boolean hasNext() {
            return this.nextPayload != null;
        }

        @Override
        public Payload next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Payload payload = this.nextPayload;
            this.nextPayload = this.getNextPayload();
            return payload;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Payload iterator does not support removal");
        }

        private Payload getNextPayload() {
            long byteSourceSize;
            ByteSource byteSource;
            try {
                if (this.offset >= this.input.size()) {
                    return null;
                }
                byteSource = this.input.slice(this.offset, this.readLen);
                byteSourceSize = byteSource.size();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            ByteSourcePayload nextPayload = new ByteSourcePayload(byteSource);
            ContentMetadata cm = this.metaData.toBuilder().contentLength(byteSourceSize).contentMD5((HashCode)null).build();
            nextPayload.setContentMetadata(BaseMutableContentMetadata.fromContentMetadata(cm));
            this.offset += byteSourceSize;
            return nextPayload;
        }
    }

    private static final class ByteSourcePayloadIterable
    implements Iterable<Payload> {
        private final ByteSource input;
        private final ContentMetadata metaData;

        ByteSourcePayloadIterable(ByteSource input, ContentMetadata metaData) {
            this.input = (ByteSource)Preconditions.checkNotNull((Object)input, (Object)"input");
            this.metaData = (ContentMetadata)Preconditions.checkNotNull((Object)metaData, (Object)"metaData");
        }

        @Override
        public Iterator<Payload> iterator() {
            return new ByteSourcePayloadIterator(this.input, this.metaData);
        }
    }

    private static final class InputStreamPayloadIterator
    implements Iterator<Payload> {
        private final InputStream input;
        private final ContentMetadata metaData;
        private Payload nextPayload;
        private final int readLen;

        InputStreamPayloadIterator(InputStream input, ContentMetadata metaData) {
            this.input = (InputStream)Preconditions.checkNotNull((Object)input, (Object)"input");
            this.metaData = (ContentMetadata)Preconditions.checkNotNull((Object)metaData, (Object)"metaData");
            this.readLen = ((Long)Preconditions.checkNotNull((Object)this.metaData.getContentLength(), (Object)"content-length")).intValue();
            this.nextPayload = this.getNextPayload();
        }

        @Override
        public boolean hasNext() {
            return this.nextPayload != null;
        }

        @Override
        public Payload next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Payload payload = this.nextPayload;
            this.nextPayload = this.getNextPayload();
            return payload;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Payload iterator does not support removal");
        }

        private Payload getNextPayload() {
            byte[] content = new byte[this.readLen];
            int offset = 0;
            try {
                while (true) {
                    int read;
                    if ((read = this.input.read(content, offset, this.readLen - offset)) <= 0) {
                        if (offset == 0) {
                            return null;
                        }
                        break;
                    }
                    offset += read;
                }
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return this.createPayload(content.length == offset ? content : Arrays.copyOf(content, offset));
        }

        private Payload createPayload(byte[] content) {
            ByteArrayPayload payload = null;
            if (content.length > 0) {
                payload = Payloads.newByteArrayPayload(content);
                ContentMetadata cm = this.metaData.toBuilder().contentLength(Long.valueOf(content.length)).contentMD5((HashCode)null).build();
                payload.setContentMetadata(BaseMutableContentMetadata.fromContentMetadata(cm));
            }
            return payload;
        }
    }

    private static final class InputStreamPayloadIterable
    implements Iterable<Payload> {
        private final InputStream input;
        private final ContentMetadata metaData;

        InputStreamPayloadIterable(InputStream input, ContentMetadata metaData) {
            this.input = (InputStream)Preconditions.checkNotNull((Object)input, (Object)"input");
            this.metaData = (ContentMetadata)Preconditions.checkNotNull((Object)metaData, (Object)"metaData");
        }

        @Override
        public Iterator<Payload> iterator() {
            return new InputStreamPayloadIterator(this.input, this.metaData);
        }
    }
}

