/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.googlecomputeengine.options.NetworkCreationOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/networks")
@Consumes(value={"application/json"})
public interface NetworkApi {
    @Named(value="Networks:get")
    @GET
    @Path(value="/{network}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Network get(@PathParam(value="network") String var1);

    @Named(value="Networks:insert")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="%7B\"name\":\"{name}\",\"IPv4Range\":\"{IPv4Range}\"%7D")
    public Operation createLegacy(@PayloadParam(value="name") String var1, @PayloadParam(value="IPv4Range") String var2);

    @Named(value="Networks:insert")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="%7B\"autoCreateSubnetworks\":false,\"name\":\"{name}\"%7D")
    public Operation createCustom(@PayloadParam(value="name") String var1);

    @Named(value="Networks:insert")
    @POST
    @Produces(value={"application/json"})
    public Operation create(@BinderParam(value=BindToJsonPayload.class) NetworkCreationOptions var1);

    @Named(value="Networks:delete")
    @DELETE
    @Path(value="/{network}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Operation delete(@PathParam(value="network") String var1);

    @Named(value="Networks:list")
    @GET
    public ListPage<Network> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Networks:list")
    @GET
    @Transform(value=NetworkPages.class)
    public Iterator<ListPage<Network>> list();

    @Named(value="Networks:list")
    @GET
    @Transform(value=NetworkPages.class)
    public Iterator<ListPage<Network>> list(ListOptions var1);

    public static final class NetworkPages
    extends BaseToIteratorOfListPage<Network, NetworkPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        NetworkPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Network>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Network>>(){

                public ListPage<Network> apply(String pageToken) {
                    return NetworkPages.this.api.networks().listPage(pageToken, options);
                }
            };
        }
    }
}

