/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.effector.AbstractEffector;
import org.apache.brooklyn.core.effector.BasicParameterType;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.mgmt.internal.EffectorUtils;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.codehaus.groovy.runtime.MethodClosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodEffector<T>
extends AbstractEffector<T> {
    private static final long serialVersionUID = 6989688364011965968L;
    private static final Logger log = LoggerFactory.getLogger(MethodEffector.class);

    public static Effector<?> create(Method m) {
        return new MethodEffector(m);
    }

    public MethodEffector(Class<?> whereEffectorDefined, String methodName) {
        this(new AnnotationsOnMethod(whereEffectorDefined, methodName), null);
    }

    public MethodEffector(Method method) {
        this(new AnnotationsOnMethod(method.getDeclaringClass(), method), null);
    }

    @Deprecated
    public MethodEffector(MethodClosure mc) {
        this(new AnnotationsOnMethod((Class)mc.getDelegate(), mc.getMethod()), null);
    }

    protected MethodEffector(AnnotationsOnMethod anns, String description) {
        super(anns.name, anns.returnType, anns.parameters, JavaGroovyEquivalents.elvis((String)description, (String)anns.description));
    }

    @Override
    public T call(Entity entity, Map parameters) {
        Object[] methods;
        if (entity instanceof AbstractEntity) {
            return EffectorUtils.invokeMethodEffector(entity, this, parameters);
        }
        Object[] parametersArray = EffectorUtils.prepareArgsForEffector(this, parameters);
        for (Method method : methods = entity.getClass().getMethods()) {
            if (!method.getName().equals(this.getName()) || parametersArray.length != method.getParameterTypes().length) continue;
            try {
                return (T)method.invoke((Object)entity, parametersArray);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        String msg = "Could not find method for effector " + this.getName() + " with " + parametersArray.length + " parameters on " + entity;
        log.warn(msg + " (throwing); available methods are: " + Arrays.toString(methods));
        throw new IllegalStateException(msg);
    }

    protected static class AnnotationsOnMethod {
        final Class<?> clazz;
        final String name;
        final String description;
        final Class<?> returnType;
        final List<ParameterType<?>> parameters;

        public AnnotationsOnMethod(Class<?> clazz, String methodName) {
            this(clazz, AnnotationsOnMethod.inferBestMethod(clazz, methodName));
        }

        public AnnotationsOnMethod(Class<?> clazz, Method method) {
            this.clazz = clazz;
            this.name = method.getName();
            this.returnType = method.getReturnType();
            org.apache.brooklyn.core.annotation.Effector effectorAnnotation = method.getAnnotation(org.apache.brooklyn.core.annotation.Effector.class);
            this.description = effectorAnnotation != null ? effectorAnnotation.description() : null;
            this.parameters = Lists.newArrayList();
            int numParameters = method.getParameterTypes().length;
            for (int i = 0; i < numParameters; ++i) {
                this.parameters.add(AnnotationsOnMethod.toParameterType(method, i));
            }
        }

        protected static ParameterType<?> toParameterType(Method method, int paramIndex) {
            Annotation[] anns = method.getParameterAnnotations()[paramIndex];
            Class<?> type = method.getParameterTypes()[paramIndex];
            EffectorParam paramAnnotation = AnnotationsOnMethod.findAnnotation(anns, EffectorParam.class);
            String name = paramAnnotation != null ? paramAnnotation.name() : null;
            String paramDescription = paramAnnotation == null || "null default value; do not mis-use! 3U=Hhfkr8wuov]WO".equals(paramAnnotation.description()) ? null : paramAnnotation.description();
            String description = paramDescription != null ? paramDescription : null;
            String paramDefaultValue = paramAnnotation == null || "null default value; do not mis-use! 3U=Hhfkr8wuov]WO".equals(paramAnnotation.defaultValue()) ? null : paramAnnotation.defaultValue();
            Object defaultValue = paramDefaultValue != null ? (Object)TypeCoercions.coerce((Object)paramDefaultValue, type) : null;
            return new BasicParameterType<Object>(name, (Class<Object>)type, description, defaultValue);
        }

        protected static <T extends Annotation> T findAnnotation(Annotation[] anns, Class<T> type) {
            for (Annotation ann : anns) {
                if (!type.isInstance(ann)) continue;
                return (T)ann;
            }
            return null;
        }

        protected static Method inferBestMethod(Class<?> clazz, String methodName) {
            Method best = null;
            for (Method it : clazz.getMethods()) {
                if (!it.getName().equals(methodName) || best != null && best.getParameterTypes().length >= it.getParameterTypes().length) continue;
                best = it;
            }
            if (best == null) {
                throw new IllegalStateException("Cannot find method " + methodName + " on " + clazz.getCanonicalName());
            }
            return best;
        }
    }
}

