/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import com.google.common.annotations.Beta;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.rest.domain.TypeDetail;
import org.apache.brooklyn.rest.domain.TypeSummary;

@Path(value="/catalog/types")
@Api(value="Catalog Types")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Beta
public interface TypeApi {
    @GET
    @ApiOperation(value="List types registered in the system", response=TypeSummary.class, responseContainer="List")
    public List<TypeSummary> list(@ApiParam(name="supertype", value="Supertype to require (beta, currently intended only for 'entity', 'policy', 'enricher', and 'location')", required=false) @QueryParam(value="supertype") String var1, @ApiParam(name="versions", value="Whether to list 'latest' of each symbolic-name or 'all' versions", required=false, defaultValue="latest") @QueryParam(value="versions") String var2, @ApiParam(name="regex", value="Regular expression to search for (in name and description)") @QueryParam(value="regex") @DefaultValue(value="") String var3, @ApiParam(name="fragment", value="Substring case-insensitive to search for (in name and description)") @QueryParam(value="fragment") @DefaultValue(value="") String var4);

    @Path(value="/{nameOrAlias}")
    @GET
    @ApiOperation(value="Get summaries for all versions and instances of a given type or alias, with best match first", response=TypeSummary.class, responseContainer="List")
    public List<TypeSummary> listVersions(@ApiParam(name="nameOrAlias", value="Type name to query", required=true) @PathParam(value="nameOrAlias") String var1);

    @Path(value="/{symbolicName}/{version}")
    @GET
    @ApiOperation(value="Get detail on a given type and version, allowing 'latest' to match the most recent version (preferring non-SNAPSHOTs)", response=TypeDetail.class)
    public TypeDetail detail(@ApiParam(name="symbolicName", value="Type name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="Version to query", required=true) @PathParam(value="version") String var2);

    @Path(value="/{symbolicName}/{version}/icon")
    @GET
    @ApiOperation(value="Returns the icon image registered for this item")
    @Produces(value={"application/image"})
    public Response icon(@ApiParam(name="symbolicName", value="Type name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="Version to query", required=true) @PathParam(value="version") String var2);
}

