/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.softlayer.domain.AutoValue_Network;
import org.jclouds.softlayer.domain.AutoValue_Network_CreateNetwork;
import org.jclouds.softlayer.domain.AutoValue_Network_DeleteNetwork;
import org.jclouds.softlayer.domain.AutoValue_Network_EditNetwork;
import org.jclouds.softlayer.domain.Subnet;

public abstract class Network {
    public abstract long accountId();

    public abstract long id();

    public abstract int cidr();

    public abstract String networkIdentifier();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract String notes();

    @Nullable
    public abstract List<Subnet> subnets();

    @SerializedNames(value={"accountId", "id", "cidr", "networkIdentifier", "name", "notes", "subnets"})
    public static Network create(long accountId, long id, int cidr, String networkIdentifier, String name, String notes, List<Subnet> subnets) {
        return new AutoValue_Network(accountId, id, cidr, networkIdentifier, name, notes, (List<Subnet>)(subnets == null ? ImmutableList.of() : ImmutableList.copyOf(subnets)));
    }

    Network() {
    }

    public static abstract class DeleteNetwork {
        public abstract long id();

        @SerializedNames(value={"id"})
        private static DeleteNetwork create(long id) {
            return DeleteNetwork.builder().id(id).build();
        }

        public static Builder builder() {
            return new AutoValue_Network_DeleteNetwork.Builder();
        }

        public static abstract class Builder {
            public abstract Builder id(long var1);

            abstract DeleteNetwork autoBuild();

            public DeleteNetwork build() {
                return this.autoBuild();
            }
        }
    }

    public static abstract class EditNetwork {
        public abstract String name();

        public abstract String notes();

        public abstract long id();

        @SerializedNames(value={"name", "notes", "id"})
        private static EditNetwork create(String name, String notes, long id) {
            return EditNetwork.builder().name(name).notes(notes).id(id).build();
        }

        public static Builder builder() {
            return new AutoValue_Network_EditNetwork.Builder();
        }

        public static abstract class Builder {
            public abstract Builder name(String var1);

            public abstract Builder notes(String var1);

            public abstract Builder id(long var1);

            abstract EditNetwork autoBuild();

            public EditNetwork build() {
                return this.autoBuild();
            }
        }
    }

    public static abstract class CreateNetwork {
        public abstract String networkIdentifier();

        public abstract String name();

        public abstract int cidr();

        @Nullable
        public abstract String notes();

        @SerializedNames(value={"networkIdentifier", "name", "cidr", "notes"})
        private static CreateNetwork create(String networkIdentifier, String name, int cidr, @Nullable String notes) {
            return CreateNetwork.builder().networkIdentifier(networkIdentifier).name(name).cidr(cidr).notes(notes).build();
        }

        public static Builder builder() {
            return new AutoValue_Network_CreateNetwork.Builder();
        }

        public static abstract class Builder {
            public abstract Builder networkIdentifier(String var1);

            public abstract Builder name(String var1);

            public abstract Builder cidr(int var1);

            @Nullable
            public abstract Builder notes(String var1);

            abstract CreateNetwork autoBuild();

            public CreateNetwork build() {
                return this.autoBuild();
            }
        }
    }
}

