/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.server;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.date.DateService;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.Nic;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.domain.Storage;
import org.jclouds.profitbricks.http.parser.nic.NicListResponseHandler;
import org.jclouds.profitbricks.http.parser.server.BaseServerResponseHandler;
import org.jclouds.profitbricks.http.parser.storage.StorageListResponseHandler;
import org.xml.sax.SAXException;

public class ServerListResponseHandler
extends BaseServerResponseHandler<List<Server>> {
    private List<Server> servers = Lists.newArrayList();

    @Inject
    ServerListResponseHandler(DateService dateService, StorageListResponseHandler storageListResponseHandler, NicListResponseHandler nicListResponseHandler) {
        super(dateService, storageListResponseHandler, nicListResponseHandler);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.useStorageParser) {
            this.storageListResponseHandler.endElement(uri, localName, qName);
        } else if (this.useNicParser) {
            this.nicListResponseHandler.endElement(uri, localName, qName);
        } else {
            this.setPropertyOnEndTag(qName);
            if ("return".equals(qName) || "servers".equals(qName) || "balancedServers".equals(qName)) {
                Server.Builder sdb = null;
                try {
                    sdb = this.builder.storages((List<Storage>)this.storageListResponseHandler.getResult()).nics((List<Nic>)this.nicListResponseHandler.getResult());
                    this.servers.add(sdb.dataCenter(this.dataCenterBuilder.build()).build());
                }
                catch (Exception ex) {
                    this.servers.add(sdb.build());
                }
                this.storageListResponseHandler.reset();
                this.nicListResponseHandler.reset();
                this.builder = Server.builder();
            }
            this.clearTextBuffer();
        }
        if ("connectedStorages".equals(qName)) {
            this.useStorageParser = false;
        } else if ("nics".equals(qName)) {
            this.useNicParser = false;
        }
    }

    @Override
    public void reset() {
        this.servers = Lists.newArrayList();
        this.dataCenterBuilder = DataCenter.builder();
    }

    public List<Server> getResult() {
        return this.servers;
    }
}

