/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.suppliers;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jclouds.util.Closeables2;

public class SSLContextBuilder {
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;

    public static final boolean isClientKeyAndCertificateData(String key, String cert) {
        return (key.startsWith("-----BEGIN RSA PRIVATE KEY-----") || key.startsWith("-----BEGIN PRIVATE KEY-----")) && cert.startsWith("-----BEGIN CERTIFICATE-----");
    }

    public SSLContextBuilder clientKeyAndCertificatePaths(String keyPath, String certPath) throws IOException, CertificateException {
        X509Certificate certificate = SSLContextBuilder.getCertificate(SSLContextBuilder.loadFile(certPath));
        PrivateKey privateKey = SSLContextBuilder.getKey(SSLContextBuilder.loadFile(keyPath));
        this.keyManager(new InMemoryKeyManager(certificate, privateKey));
        return this;
    }

    public SSLContextBuilder clientKeyAndCertificateData(String keyData, String certData) throws CertificateException {
        X509Certificate certificate = SSLContextBuilder.getCertificate(certData);
        PrivateKey privateKey = SSLContextBuilder.getKey(keyData);
        this.keyManager(new InMemoryKeyManager(certificate, privateKey));
        return this;
    }

    public SSLContextBuilder caCertificatePath(String caCertPath) {
        try {
            this.trustManagers = this.getTrustManagerWithCaCert(SSLContextBuilder.loadFile(caCertPath));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    public SSLContextBuilder caCertificateData(String caCertPath) {
        this.trustManagers = this.getTrustManagerWithCaCert(caCertPath);
        return this;
    }

    public SSLContextBuilder keyManager(KeyManager keyManager) {
        this.keyManagers = new KeyManager[]{keyManager};
        return this;
    }

    public SSLContextBuilder trustManager(TrustManager trustManager) {
        this.trustManagers = new TrustManager[]{trustManager};
        return this;
    }

    public SSLContext build() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(this.keyManagers, this.trustManagers, new SecureRandom());
        return sslContext;
    }

    private TrustManager[] getTrustManagerWithCaCert(String caCertData) {
        try {
            X509Certificate caCert = SSLContextBuilder.getCertificate(caCertData);
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", caCert);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            return tmf.getTrustManagers();
        }
        catch (GeneralSecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static X509Certificate getCertificate(String certificate) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificate.getBytes(Charsets.UTF_8)));
        }
        catch (CertificateException ex) {
            throw new RuntimeException("Invalid certificate", ex);
        }
    }

    private static PrivateKey getKey(String privateKey) {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKey));
        try {
            Object object = pemParser.readObject();
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            KeyPair keyPair = converter.getKeyPair((PEMKeyPair)object);
            PrivateKey privateKey2 = keyPair.getPrivate();
            return privateKey2;
        }
        catch (IOException ex) {
            throw new RuntimeException("Invalid private key", ex);
        }
        finally {
            Closeables2.closeQuietly((Closeable)pemParser);
        }
    }

    private static String loadFile(String filePath) throws IOException {
        return Files.toString((File)new File(filePath), (Charset)Charsets.UTF_8);
    }

    private static class InMemoryKeyManager
    extends X509ExtendedKeyManager {
        private static final String DEFAULT_ALIAS = "docker";
        private final X509Certificate certificate;
        private final PrivateKey privateKey;

        public InMemoryKeyManager(X509Certificate certificate, PrivateKey privateKey) throws CertificateException {
            this.certificate = certificate;
            this.privateKey = privateKey;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return DEFAULT_ALIAS;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return DEFAULT_ALIAS;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return new X509Certificate[]{this.certificate};
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return new String[]{DEFAULT_ALIAS};
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.privateKey;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return new String[]{DEFAULT_ALIAS};
        }
    }
}

