/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.crypto.SecureKeys;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.functions.Sha512Crypt;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.domain.LiteralStatement;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.scriptbuilder.statements.login.ReplaceShadowPasswordEntry;
import org.jclouds.scriptbuilder.statements.ssh.AuthorizeRSAPublicKeys;
import org.jclouds.scriptbuilder.statements.ssh.SshStatements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateUserStatements {
    private static final Logger LOG = LoggerFactory.getLogger(CreateUserStatements.class);
    private final LoginCredentials createdUserCredentials;
    private final List<Statement> statements;

    CreateUserStatements(LoginCredentials creds, List<Statement> statements) {
        this.createdUserCredentials = creds;
        this.statements = statements;
    }

    public LoginCredentials credentials() {
        return this.createdUserCredentials;
    }

    public List<Statement> statements() {
        return this.statements;
    }

    public static CreateUserStatements get(JcloudsLocation location, @Nullable Image image, ConfigBag config) {
        Preconditions.checkNotNull((Object)location, (Object)"location argument required");
        String user = (String)Preconditions.checkNotNull((Object)location.getUser(config), (Object)"user required");
        boolean isWindows = location.isWindows(image, config);
        String explicitLoginUser = (String)config.get(JcloudsLocation.LOGIN_USER);
        String loginUser = JavaGroovyEquivalents.groovyTruth((String)explicitLoginUser) ? explicitLoginUser : (image != null && image.getDefaultCredentials() != null ? image.getDefaultCredentials().identity : null);
        boolean dontCreateUser = (Boolean)config.get(JcloudsLocation.DONT_CREATE_USER);
        boolean grantUserSudo = (Boolean)config.get(JcloudsLocation.GRANT_USER_SUDO);
        LocationConfigUtils.OsCredential credential = LocationConfigUtils.getOsCredential((ConfigBag)config, (ResourceUtils)ResourceUtils.create((Object)location));
        credential.checkNoErrors().logAnyWarnings();
        String passwordToSet = Strings.isNonBlank((CharSequence)credential.getPassword()) ? credential.getPassword() : Identifiers.makeRandomId((int)12);
        ArrayList statements = Lists.newArrayList();
        LoginCredentials createdUserCreds = null;
        if (dontCreateUser) {
            if (Strings.isBlank((CharSequence)user)) {
                LOG.info("Not setting up user {} (subsequently using loginUser {})", (Object)user, (Object)loginUser);
                config.put(JcloudsLocation.USER, (Object)loginUser);
            } else {
                LOG.info("Not creating user {}, and not installing its password or authorizing keys (assuming it exists)", (Object)user);
                if (credential.isUsingPassword()) {
                    createdUserCreds = LoginCredentials.builder().user(user).password(credential.getPassword()).build();
                    if (Boolean.FALSE.equals(config.get(JcloudsLocation.DISABLE_ROOT_AND_PASSWORD_SSH))) {
                        statements.add(SshStatements.sshdConfig((Map)ImmutableMap.of((Object)"PasswordAuthentication", (Object)"yes")));
                    }
                } else if (credential.hasKey()) {
                    createdUserCreds = LoginCredentials.builder().user(user).privateKey(credential.getPrivateKeyData()).build();
                }
            }
        } else if (isWindows) {
            LOG.warn("Not creating or configuring user on Windows VM, despite " + JcloudsLocation.DONT_CREATE_USER.getName() + " set to false");
            if (config.get(JcloudsLocation.USER) != null) {
                config.put(JcloudsLocation.USER, (Object)"");
            }
            if (config.get(JcloudsLocation.PASSWORD) != null) {
                config.put(JcloudsLocation.PASSWORD, (Object)"");
            }
            if (config.get(JcloudsLocation.PRIVATE_KEY_DATA) != null) {
                config.put(JcloudsLocation.PRIVATE_KEY_DATA, (Object)"");
            }
            if (config.get(JcloudsLocation.PRIVATE_KEY_FILE) != null) {
                config.put(JcloudsLocation.PRIVATE_KEY_FILE, (Object)"");
            }
            if (config.get(JcloudsLocation.PUBLIC_KEY_DATA) != null) {
                config.put(JcloudsLocation.PUBLIC_KEY_DATA, (Object)"");
            }
            if (config.get(JcloudsLocation.PUBLIC_KEY_FILE) != null) {
                config.put(JcloudsLocation.PUBLIC_KEY_FILE, (Object)"");
            }
        } else if (Strings.isBlank((CharSequence)user) || user.equals(loginUser) || user.equals("root")) {
            boolean useKey = Strings.isNonBlank((CharSequence)credential.getPublicKeyData());
            if (Strings.isBlank((CharSequence)user)) {
                user = loginUser;
                config.put(JcloudsLocation.USER, (Object)user);
            }
            statements.add(new ReplaceShadowPasswordEntry(Sha512Crypt.function(), user, passwordToSet));
            createdUserCreds = LoginCredentials.builder().user(user).password(passwordToSet).build();
            if (useKey) {
                statements.add(new AuthorizeRSAPublicKeys("~" + user + "/.ssh", (Iterable)ImmutableList.of((Object)credential.getPublicKeyData()), null));
                if (Strings.isNonBlank((CharSequence)credential.getPrivateKeyData())) {
                    createdUserCreds = LoginCredentials.builder().user(user).privateKey(credential.getPrivateKeyData()).build();
                }
            }
            if (!useKey || Boolean.FALSE.equals(config.get(JcloudsLocation.DISABLE_ROOT_AND_PASSWORD_SSH))) {
                statements.add(SshStatements.sshdConfig((Map)ImmutableMap.of((Object)"PasswordAuthentication", (Object)"yes")));
                if (user.equals("root")) {
                    statements.add(SshStatements.sshdConfig((Map)ImmutableMap.of((Object)"PermitRootLogin", (Object)"yes")));
                }
            }
        } else {
            String pubKey = credential.getPublicKeyData();
            String privKey = credential.getPrivateKeyData();
            if (credential.isEmpty()) {
                if (!config.containsKey(JcloudsLocation.PRIVATE_KEY_FILE)) {
                    LOG.info("Default SSH keys not found or not usable; will create new keys for each machine. Create ~/.ssh/id_rsa or set {} / {} / {} as appropriate for this location if you wish to be able to log in without Brooklyn.", new Object[]{JcloudsLocation.PRIVATE_KEY_FILE.getName(), JcloudsLocation.PRIVATE_KEY_PASSPHRASE.getName(), JcloudsLocation.PASSWORD.getName()});
                }
                KeyPair newKeyPair = SecureKeys.newKeyPair();
                pubKey = SecureKeys.toPub((KeyPair)newKeyPair);
                privKey = SecureKeys.toPem((KeyPair)newKeyPair);
                LOG.debug("Brooklyn key being created for " + user + " at new machine " + location + " is:\n" + privKey);
            }
            AdminAccess.Builder adminBuilder = AdminAccess.builder().adminUsername(user).grantSudoToAdminUser(grantUserSudo);
            adminBuilder.cryptFunction(Sha512Crypt.function());
            boolean useKey = Strings.isNonBlank((CharSequence)pubKey);
            adminBuilder.cryptFunction(Sha512Crypt.function());
            adminBuilder.adminPassword(passwordToSet);
            LOG.debug("Password '{}' being created for user '{}' at the machine we are about to provision in {}; {}", new Object[]{passwordToSet, user, location, useKey ? "however a key will be used to access it" : "this will be the only way to log in"});
            if (grantUserSudo && ((Boolean)config.get(JcloudsLocationConfig.DISABLE_ROOT_AND_PASSWORD_SSH)).booleanValue()) {
                adminBuilder.resetLoginPassword(true);
                adminBuilder.loginPassword(Identifiers.makeRandomId((int)12));
            } else {
                adminBuilder.resetLoginPassword(false);
                adminBuilder.loginPassword(Identifiers.makeRandomId((int)12) + "-ignored");
            }
            if (useKey) {
                adminBuilder.authorizeAdminPublicKey(true).adminPublicKey(pubKey);
            } else {
                adminBuilder.authorizeAdminPublicKey(false).adminPublicKey(Identifiers.makeRandomId((int)12) + "-ignored");
            }
            adminBuilder.installAdminPrivateKey(false).adminPrivateKey(Identifiers.makeRandomId((int)12) + "-ignored");
            adminBuilder.lockSsh(useKey && grantUserSudo && (Boolean)config.get(JcloudsLocationConfig.DISABLE_ROOT_AND_PASSWORD_SSH) != false);
            statements.add(adminBuilder.build());
            if (useKey) {
                createdUserCreds = LoginCredentials.builder().user(user).privateKey(privKey).build();
            } else if (passwordToSet != null) {
                createdUserCreds = LoginCredentials.builder().user(user).password(passwordToSet).build();
            }
            if (!useKey || Boolean.FALSE.equals(config.get(JcloudsLocation.DISABLE_ROOT_AND_PASSWORD_SSH))) {
                statements.add(SshStatements.sshdConfig((Map)ImmutableMap.of((Object)"PasswordAuthentication", (Object)"yes")));
            }
        }
        String customTemplateOptionsScript = (String)config.get(JcloudsLocation.CUSTOM_TEMPLATE_OPTIONS_SCRIPT_CONTENTS);
        if (Strings.isNonBlank((CharSequence)customTemplateOptionsScript)) {
            statements.add(new LiteralStatement(customTemplateOptionsScript));
        }
        LOG.debug("Machine we are about to create in {} will be customized with: {}", (Object)location, (Object)statements);
        return new CreateUserStatements(createdUserCreds, statements);
    }
}

