/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.networking;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.networking.SecurityGroupDefinition;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.features.AWSSecurityGroupApi;
import org.jclouds.aws.ec2.options.CreateSecurityGroupOptions;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.domain.Location;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.rest.ApiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SecurityGroupTool {
    private static final Logger log = LoggerFactory.getLogger(SecurityGroupTool.class);
    protected final JcloudsLocation location;
    protected final SecurityGroupDefinition sgDef;

    public SecurityGroupTool(JcloudsLocation location, SecurityGroupDefinition sgDef) {
        this.location = (JcloudsLocation)Preconditions.checkNotNull((Object)location);
        this.sgDef = (SecurityGroupDefinition)Preconditions.checkNotNull((Object)sgDef);
    }

    public String getName() {
        return this.sgDef.getName();
    }

    public void apply() {
        Optional sgExtO = this.location.getComputeService().getSecurityGroupExtension();
        if (!sgExtO.isPresent()) {
            throw new IllegalStateException("Advanced networking not supported in this location (" + this.location + ")");
        }
        SecurityGroupExtension sgExt = (SecurityGroupExtension)sgExtO.get();
        org.jclouds.compute.domain.SecurityGroup sg = this.findSecurityGroupWithName(sgExt, this.getName());
        if (sg == null) {
            Location sgLoc = null;
            try {
                sg = sgExt.createSecurityGroup(this.getName(), sgLoc);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                sg = this.findSecurityGroupWithName(sgExt, this.getName());
                if (sg == null) {
                    throw Exceptions.propagate((Throwable)e);
                }
                log.debug("Looks like parallel thread created security group " + this.getName() + "; ignoring error in our thread (" + e + ") as we now have an SG");
            }
        }
        if (sg == null) {
            throw new IllegalStateException("Unable to find or create security group ID for " + this.getName());
        }
        this.addPermissions(sgExt, sg);
    }

    protected org.jclouds.compute.domain.SecurityGroup findSecurityGroupWithName(SecurityGroupExtension sgExt, String name) {
        Set groups = sgExt.listSecurityGroups();
        String nameAlt = name.startsWith("jclouds#") ? Strings.removeFromStart((String)name, (String)"jclouds#") : "jclouds#" + name;
        for (org.jclouds.compute.domain.SecurityGroup g : groups) {
            if (name.equals(g.getName())) {
                return g;
            }
            if (!nameAlt.equals(g.getName())) continue;
            return g;
        }
        return null;
    }

    protected void addPermissions(SecurityGroupExtension sgExt, org.jclouds.compute.domain.SecurityGroup sg) {
        Object api = ((ApiContext)this.location.getComputeService().getContext().unwrap()).getApi();
        if (api instanceof AWSEC2Api) {
            String region = AWSUtils.getRegionFromLocationOrNull((Location)sg.getLocation());
            String id = sg.getProviderId();
            ((AWSSecurityGroupApi)((AWSEC2Api)api).getSecurityGroupApi().get()).authorizeSecurityGroupIngressInRegion(region, id, this.sgDef.getPermissions());
        } else {
            for (IpPermission p : this.sgDef.getPermissions()) {
                sgExt.addIpPermission(p, sg);
            }
        }
    }

    protected void applyOldEc2(AWSEC2Api client) {
        String region = (String)this.location.getConfig(JcloudsLocationConfig.CLOUD_REGION_ID);
        if (region == null) {
            log.warn("No region set for " + this.location + "; assuming EC2");
            region = "us-east-1";
        }
        Set groups = ((AWSSecurityGroupApi)client.getSecurityGroupApi().get()).describeSecurityGroupsInRegion(region, new String[]{this.getName()});
        String id = null;
        if (groups.isEmpty()) {
            try {
                id = ((AWSSecurityGroupApi)client.getSecurityGroupApi().get()).createSecurityGroupInRegionAndReturnId(region, this.getName(), "Brooklyn-managed security group " + this.getName(), new CreateSecurityGroupOptions[0]);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                groups = ((AWSSecurityGroupApi)client.getSecurityGroupApi().get()).describeSecurityGroupsInRegion(region, new String[]{this.getName()});
                if (groups.isEmpty()) {
                    throw Exceptions.propagate((Throwable)e);
                }
                log.debug("Looks like parallel thread created security group " + this.getName() + "; ignoring error in our thread (" + e + ") as we now have an SG");
            }
        }
        if (!groups.isEmpty()) {
            if (groups.size() > 1) {
                log.warn("Multiple security groups matching '" + this.getName() + "' (using the first): " + groups);
            }
            id = ((SecurityGroup)groups.iterator().next()).getId();
        }
        if (id == null) {
            throw new IllegalStateException("Unable to find or create security group ID for " + this.getName());
        }
        ((AWSSecurityGroupApi)client.getSecurityGroupApi().get()).authorizeSecurityGroupIngressInRegion(region, id, this.sgDef.getPermissions());
    }
}

