/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.pool;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import java.util.Map;
import org.apache.brooklyn.location.jclouds.pool.MachineSet;
import org.apache.brooklyn.location.jclouds.pool.ReusableMachineTemplate;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Processor;
import org.jclouds.domain.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachinePoolPredicates {
    private static final Logger log = LoggerFactory.getLogger(MachinePoolPredicates.class);

    public static Predicate<NodeMetadata> except(final MachineSet removedItems) {
        return new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata input) {
                return !removedItems.contains(input);
            }
        };
    }

    public static Predicate<NodeMetadata> except(Predicate<NodeMetadata> predicateToExclude) {
        return Predicates.not(predicateToExclude);
    }

    public static Predicate<NodeMetadata> matching(final ReusableMachineTemplate template) {
        return new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata input) {
                return MachinePoolPredicates.matches(template, input);
            }
        };
    }

    public static Predicate<NodeMetadata> withTag(final String tag) {
        return new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata input) {
                return input.getTags().contains(tag);
            }
        };
    }

    public static Predicate<NodeMetadata> compose(Predicate<NodeMetadata> ... predicates) {
        return Predicates.and(predicates);
    }

    public static boolean matches(ReusableMachineTemplate template, NodeMetadata m) {
        try {
            if (!m.getTags().containsAll(template.getTags(false))) {
                return false;
            }
            if (!MachinePoolPredicates.isSubMapOf(template.getUserMetadata(false), m.getUserMetadata())) {
                return false;
            }
            if (template.getMinRam() != null && m.getHardware().getRam() < template.getMinRam()) {
                return false;
            }
            if (template.getMinCores() != null) {
                double numCores = 0.0;
                for (Processor p : m.getHardware().getProcessors()) {
                    numCores += p.getCores();
                }
                if (numCores + 0.001 < template.getMinCores()) {
                    return false;
                }
            }
            if (template.getIs64bit() != null && m.getOperatingSystem().is64Bit() != template.getIs64bit().booleanValue()) {
                return false;
            }
            if (!(template.getOsFamily() == null || m.getOperatingSystem() != null && template.getOsFamily().equals((Object)m.getOperatingSystem().getFamily()))) {
                return false;
            }
            if (!(template.getOsNameMatchesRegex() == null || m.getOperatingSystem() != null && m.getOperatingSystem().getName() != null && m.getOperatingSystem().getName().matches(template.getOsNameMatchesRegex()))) {
                return false;
            }
            return template.getLocationId() == null || MachinePoolPredicates.isLocationContainedIn(m.getLocation(), template.getLocationId());
        }
        catch (Exception e) {
            log.warn("Error (rethrowing) trying to match " + m + " against " + template + ": " + e, (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static boolean isLocationContainedIn(Location location, String locationId) {
        if (location == null) {
            return false;
        }
        if (locationId.equals(location.getId())) {
            return true;
        }
        return MachinePoolPredicates.isLocationContainedIn(location.getParent(), locationId);
    }

    public static boolean isSubMapOf(Map<String, String> sub, Map<String, String> bigger) {
        for (Map.Entry<String, String> e : sub.entrySet()) {
            if (e.getValue() == null) {
                if (!bigger.containsKey(e.getKey())) {
                    return false;
                }
                if (bigger.get(e.getKey()) == null) continue;
                return false;
            }
            if (e.getValue().equals(bigger.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }
}

