/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates.customize;

import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.softlayer.compute.options.SoftLayerTemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NetworkNameOption
implements TemplateOptionCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkNameOption.class);

    NetworkNameOption() {
    }

    @Override
    public void apply(TemplateOptions t, ConfigBag props, Object v) {
        if (t instanceof AWSEC2TemplateOptions) {
            ((AWSEC2TemplateOptions)t).subnetId((String)v);
        } else {
            if (!NetworkNameOption.isGoogleComputeTemplateOptions(t)) {
                if (t instanceof SoftLayerTemplateOptions) {
                    LOG.warn("networkName is not be supported in SoftLayer; use `templateOptions` with `primaryNetworkComponentNetworkVlanId` or `primaryNetworkBackendComponentNetworkVlanId`");
                } else if (!(t instanceof CloudStackTemplateOptions) && !(t instanceof NovaTemplateOptions)) {
                    LOG.warn("networkName is experimental in many jclouds endpoints may not be supported in this cloud");
                }
            }
            t.networks(new String[]{(String)v});
        }
    }

    private static boolean isGoogleComputeTemplateOptions(TemplateOptions t) {
        return t.getClass().getName().equals("org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions");
    }
}

