/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.chef;

import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyPair;
import org.apache.brooklyn.entity.chef.KnifeConvergeTaskFactory;
import org.apache.brooklyn.entity.chef.KnifeTaskFactory;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.crypto.SecureKeys;

public class ChefServerTasks {
    private static File chefKeyDir;

    private static synchronized File getExtractedKeysDir() {
        if (chefKeyDir == null) {
            chefKeyDir = Files.createTempDir();
            chefKeyDir.deleteOnExit();
        }
        return chefKeyDir;
    }

    static synchronized File extractKeyFile(SshMachineLocation machine) {
        File f = new File(ChefServerTasks.getExtractedKeysDir(), machine.getAddress().getHostName() + ".pem");
        if (f.exists()) {
            return f;
        }
        KeyPair data = machine.findKeyPair();
        if (data == null) {
            return null;
        }
        try {
            f.deleteOnExit();
            Files.write((CharSequence)SecureKeys.toPem((KeyPair)data), (File)f, (Charset)Charset.defaultCharset());
            return f;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static KnifeTaskFactory<Boolean> isKnifeInstalled() {
        return new KnifeTaskFactory("knife install check").knifeAddParameters("node list", new String[0]).notThrowingOnCommonKnifeErrors().returningIsExitCodeZero();
    }

    public static KnifeConvergeTaskFactory<String> knifeConvergeTask() {
        return new KnifeConvergeTaskFactory("knife converge").requiringZeroAndReturningStdout();
    }

    public static KnifeConvergeTaskFactory<String> knifeConvergeRunList(String runList) {
        return ChefServerTasks.knifeConvergeTask().knifeRunList(runList).knifeSudo(true);
    }

    public static KnifeConvergeTaskFactory<String> knifeConvergeRunListWindowsSsh(String runList) {
        return ChefServerTasks.knifeConvergeTask().knifeRunList(runList).knifeSudo(false).knifeAddExtraBootstrapParameters("windows ssh", new String[0]);
    }

    public static KnifeConvergeTaskFactory<String> knifeConvergeRunListWindowsWinrm(String runList) {
        return ChefServerTasks.knifeConvergeTask().knifeRunList(runList).knifeSudo(false).knifeAddExtraBootstrapParameters("windows winrm", new String[0]).knifePortUseKnifeDefault();
    }
}

