/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.ui.modularity.metadata.registry.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import org.apache.brooklyn.ui.modularity.metadata.registry.UiMetadataRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiMetadataRegistryImpl
implements UiMetadataRegistry {
    private static final Logger logger = LoggerFactory.getLogger(UiMetadataRegistryImpl.class);
    final Table<String, String, Map<String, String>> metadataTable = HashBasedTable.create();

    @Override
    public void registerMetadata(String type, String id, Map<String, String> metadata) {
        this.modifyMetadata(type, id, metadata);
    }

    @Override
    public void modifyMetadata(String type, String id, Map<String, String> metadata) {
        this.metadataTable.put((Object)type, (Object)id, metadata);
    }

    @Override
    public void unregisterMetadata(String type, String id) {
        this.metadataTable.remove((Object)type, (Object)id);
    }

    @Override
    public Map<String, Map<String, String>> getById(String id) {
        return this.metadataTable.column((Object)id);
    }

    @Override
    public Map<String, Map<String, String>> getByType(String type) {
        return this.metadataTable.row((Object)type);
    }

    @Override
    public Map<String, String> getByTypeAndId(String type, String id) {
        return (Map)this.metadataTable.get((Object)type, (Object)id);
    }

    @Override
    public Map<String, Map<String, Map<String, String>>> getAll() {
        return this.metadataTable.rowMap();
    }
}

