/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.components.jaspi.impl;

import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;

public class ServerAuthContextImpl
implements ServerAuthContext {
    private final List<ServerAuthModule> serverAuthModules;

    public ServerAuthContextImpl(List<ServerAuthModule> serverAuthModules) {
        this.serverAuthModules = serverAuthModules;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        for (ServerAuthModule serverAuthModule : this.serverAuthModules) {
            serverAuthModule.cleanSubject(messageInfo, subject);
        }
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        for (ServerAuthModule serverAuthModule : this.serverAuthModules) {
            AuthStatus result = serverAuthModule.secureResponse(messageInfo, serviceSubject);
            if (result == AuthStatus.SEND_SUCCESS) continue;
            if (result == AuthStatus.SEND_CONTINUE || result == AuthStatus.SEND_FAILURE) {
                return result;
            }
            throw new AuthException("Invalid AuthStatus " + result + " from server auth module secureResponse: " + serverAuthModule);
        }
        return AuthStatus.SEND_SUCCESS;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        for (ServerAuthModule serverAuthModule : this.serverAuthModules) {
            AuthStatus result = serverAuthModule.validateRequest(messageInfo, clientSubject, serviceSubject);
            if (result == AuthStatus.SUCCESS) continue;
            if (result == AuthStatus.SEND_SUCCESS || result == AuthStatus.SEND_CONTINUE || result == AuthStatus.FAILURE) {
                return result;
            }
            throw new AuthException("Invalid AuthStatus " + result + " from server auth module validateRequest: " + serverAuthModule);
        }
        return AuthStatus.SUCCESS;
    }
}

