/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.List;
import org.jclouds.azurecompute.arm.domain.AddressSpace;
import org.jclouds.azurecompute.arm.domain.Subnet;
import org.jclouds.azurecompute.arm.domain.VirtualNetwork;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_VirtualNetwork_VirtualNetworkProperties
extends VirtualNetwork.VirtualNetworkProperties {
    private final String provisioningState;
    private final String resourceGuid;
    private final AddressSpace addressSpace;
    private final List<Subnet> subnets;

    private AutoValue_VirtualNetwork_VirtualNetworkProperties(@Nullable String provisioningState, @Nullable String resourceGuid, AddressSpace addressSpace, @Nullable List<Subnet> subnets) {
        this.provisioningState = provisioningState;
        this.resourceGuid = resourceGuid;
        this.addressSpace = addressSpace;
        this.subnets = subnets;
    }

    @Override
    @Nullable
    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    @Nullable
    public String resourceGuid() {
        return this.resourceGuid;
    }

    @Override
    public AddressSpace addressSpace() {
        return this.addressSpace;
    }

    @Override
    @Nullable
    public List<Subnet> subnets() {
        return this.subnets;
    }

    public String toString() {
        return "VirtualNetworkProperties{provisioningState=" + this.provisioningState + ", resourceGuid=" + this.resourceGuid + ", addressSpace=" + this.addressSpace + ", subnets=" + this.subnets + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VirtualNetwork.VirtualNetworkProperties) {
            VirtualNetwork.VirtualNetworkProperties that = (VirtualNetwork.VirtualNetworkProperties)o;
            return (this.provisioningState == null ? that.provisioningState() == null : this.provisioningState.equals(that.provisioningState())) && (this.resourceGuid == null ? that.resourceGuid() == null : this.resourceGuid.equals(that.resourceGuid())) && this.addressSpace.equals(that.addressSpace()) && (this.subnets == null ? that.subnets() == null : this.subnets.equals(that.subnets()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.provisioningState == null ? 0 : this.provisioningState.hashCode();
        h *= 1000003;
        h ^= this.resourceGuid == null ? 0 : this.resourceGuid.hashCode();
        h *= 1000003;
        h ^= this.addressSpace.hashCode();
        h *= 1000003;
        return h ^= this.subnets == null ? 0 : this.subnets.hashCode();
    }

    @Override
    public VirtualNetwork.VirtualNetworkProperties.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends VirtualNetwork.VirtualNetworkProperties.Builder {
        private String provisioningState;
        private String resourceGuid;
        private AddressSpace addressSpace;
        private List<Subnet> subnets;

        Builder() {
        }

        private Builder(VirtualNetwork.VirtualNetworkProperties source) {
            this.provisioningState = source.provisioningState();
            this.resourceGuid = source.resourceGuid();
            this.addressSpace = source.addressSpace();
            this.subnets = source.subnets();
        }

        @Override
        public VirtualNetwork.VirtualNetworkProperties.Builder provisioningState(@Nullable String provisioningState) {
            this.provisioningState = provisioningState;
            return this;
        }

        @Override
        public VirtualNetwork.VirtualNetworkProperties.Builder resourceGuid(@Nullable String resourceGuid) {
            this.resourceGuid = resourceGuid;
            return this;
        }

        @Override
        public VirtualNetwork.VirtualNetworkProperties.Builder addressSpace(AddressSpace addressSpace) {
            if (addressSpace == null) {
                throw new NullPointerException("Null addressSpace");
            }
            this.addressSpace = addressSpace;
            return this;
        }

        @Override
        public VirtualNetwork.VirtualNetworkProperties.Builder subnets(@Nullable List<Subnet> subnets) {
            this.subnets = subnets;
            return this;
        }

        @Override
        @Nullable
        List<Subnet> subnets() {
            return this.subnets;
        }

        @Override
        VirtualNetwork.VirtualNetworkProperties autoBuild() {
            String missing = "";
            if (this.addressSpace == null) {
                missing = missing + " addressSpace";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_VirtualNetwork_VirtualNetworkProperties(this.provisioningState, this.resourceGuid, this.addressSpace, this.subnets);
        }
    }
}

