/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.rest.api.TypeApi;
import org.apache.brooklyn.rest.domain.TypeDetail;
import org.apache.brooklyn.rest.domain.TypeSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.TypeTransformer;
import org.apache.brooklyn.rest.util.BrooklynRestResourceUtils;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
@Beta
public class TypeResource
extends AbstractBrooklynRestResource
implements TypeApi {
    private static final Logger log = LoggerFactory.getLogger(TypeResource.class);
    private static final String LATEST = "latest";
    private static final String ALL = "all";
    private static Set<String> missingIcons = MutableSet.of();

    static boolean isLatestOnly(String versions, boolean defaultValue) {
        if (ALL.equalsIgnoreCase(versions)) {
            return false;
        }
        if (LATEST.equalsIgnoreCase(versions)) {
            return true;
        }
        if (Strings.isNonBlank((CharSequence)versions)) {
            log.warn("Invalid 'versions' argument '" + versions + "' when listing types; should be 'all' or 'latest'");
        }
        return defaultValue;
    }

    public List<TypeSummary> list(String supertype, String versions, String regex, String fragment) {
        MutableList filters = MutableList.of().append((Object)RegisteredTypePredicates.entitledToSee((ManagementContext)this.mgmt()));
        if (Strings.isNonBlank((CharSequence)supertype)) {
            if ("entity".equals(supertype)) {
                supertype = Entity.class.getName();
            } else if ("enricher".equals(supertype)) {
                supertype = Enricher.class.getName();
            } else if ("policy".equals(supertype)) {
                supertype = Policy.class.getName();
            } else if ("location".equals(supertype)) {
                supertype = Location.class.getName();
            } else if ("application".equals(supertype)) {
                supertype = Application.class.getName();
            }
            filters.add(RegisteredTypePredicates.subtypeOf((String)supertype));
        }
        if (TypeResource.isLatestOnly(versions, true)) {
            filters.add(RegisteredTypePredicates.isBestVersion((ManagementContext)this.mgmt()));
        }
        if (Strings.isNonEmpty((CharSequence)regex)) {
            filters.add(RegisteredTypePredicates.nameOrAlias((Predicate)StringPredicates.containsRegex((String)regex)));
        }
        if (Strings.isNonEmpty((CharSequence)fragment)) {
            filters.add(RegisteredTypePredicates.nameOrAlias((Predicate)StringPredicates.containsLiteralIgnoreCase((String)fragment)));
        }
        Predicate filter = Predicates.and((Iterable)filters);
        ImmutableList sortedItems = FluentIterable.from((Iterable)this.brooklyn().getTypeRegistry().getMatching(filter)).toSortedList(RegisteredTypes.RegisteredTypeNameThenBestFirstComparator.INSTANCE);
        return TypeResource.toTypeSummary(this.brooklyn(), (Iterable<RegisteredType>)sortedItems, this.ui.getBaseUriBuilder());
    }

    static List<TypeSummary> toTypeSummary(BrooklynRestResourceUtils brooklyn, Iterable<RegisteredType> sortedItems, UriBuilder uriBuilder) {
        MutableList result = MutableList.of();
        for (RegisteredType t : sortedItems) {
            result.add(TypeTransformer.summary(brooklyn, t, uriBuilder));
        }
        return result;
    }

    public List<TypeSummary> listVersions(String nameOrAlias) {
        Predicate filter = Predicates.and((Predicate)RegisteredTypePredicates.entitledToSee((ManagementContext)this.mgmt()), (Predicate)RegisteredTypePredicates.nameOrAlias((String)nameOrAlias));
        ImmutableList sortedItems = FluentIterable.from((Iterable)this.brooklyn().getTypeRegistry().getMatching(filter)).toSortedList(RegisteredTypes.RegisteredTypeNameThenBestFirstComparator.INSTANCE);
        return TypeResource.toTypeSummary(this.brooklyn(), (Iterable<RegisteredType>)sortedItems, this.ui.getBaseUriBuilder());
    }

    public TypeDetail detail(String symbolicName, String version) {
        RegisteredType item = this.lookup(symbolicName, version);
        return TypeTransformer.detail(this.brooklyn(), item, this.ui.getBaseUriBuilder());
    }

    protected RegisteredType lookup(String symbolicName, String version) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(symbolicName + ":" + version))) {
            throw WebResourceUtils.forbidden("User '%s' not permitted to see info on this type (including whether or not installed)", Entitlements.getEntitlementContext().user());
        }
        RegisteredType item = LATEST.equalsIgnoreCase(version) ? this.brooklyn().getTypeRegistry().get(symbolicName) : this.brooklyn().getTypeRegistry().get(symbolicName, version);
        if (item == null) {
            throw WebResourceUtils.notFound("Entity with id '%s:%s' not found", symbolicName, version);
        }
        return item;
    }

    @Deprecated
    public Response icon(String symbolicName, String version) {
        return this.icon(symbolicName, version, null);
    }

    public Response icon(String symbolicName, String version, String iconUrl) {
        RegisteredType item = this.lookup(symbolicName, version);
        return TypeResource.produceIcon(this.mgmt(), this.brooklyn(), item, iconUrl);
    }

    static Response produceIcon(ManagementContext mgmt, BrooklynRestResourceUtils brooklyn, RegisteredType result) {
        return TypeResource.produceIcon(mgmt, brooklyn, result, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Response produceIcon(ManagementContext mgmt, BrooklynRestResourceUtils brooklyn, RegisteredType result, String url) {
        if (Strings.isBlank((CharSequence)url)) {
            url = result.getIconUrl();
        }
        if (url == null) {
            log.debug("No icon available for " + result + "; returning " + Response.Status.NO_CONTENT);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (brooklyn.isUrlServerSideAndSafe(url)) {
            log.trace("Loading and returning " + url + " as icon for " + result);
            MediaType mime = WebResourceUtils.getImageMediaTypeFromExtension(Files.getFileExtension((String)url));
            try {
                InputStream content = ResourceUtils.create((RegisteredType)result, (ManagementContext)mgmt, (boolean)true).getResourceFromUrl(url);
                return Response.ok((Object)content, (MediaType)mime).build();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                Set<String> set = missingIcons;
                synchronized (set) {
                    if (missingIcons.add(url)) {
                        log.warn("Missing icon data for " + result.getId() + ", expected at: " + url + " (subsequent messages will log debug only)");
                        log.debug("Trace for missing icon data at " + url + ": " + e, (Throwable)e);
                    } else {
                        log.debug("Missing icon data for " + result.getId() + ", expected at: " + url + " (already logged WARN and error details)");
                    }
                }
                throw WebResourceUtils.notFound("Icon unavailable for %s", result.getId());
            }
        }
        log.debug("Returning redirect to " + url + " as icon for " + result);
        return Response.temporaryRedirect((URI)URI.create(url)).build();
    }
}

