/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.catalog;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.catalog.ServiceEndpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Service;

@Singleton
public class V2ServiceCatalog
implements Supplier<List<ServiceEndpoint>> {
    @Resource
    private Logger logger = Logger.NULL;
    private final Supplier<AuthInfo> authInfo;

    @Inject
    V2ServiceCatalog(Supplier<AuthInfo> authInfo) {
        this.authInfo = authInfo;
    }

    public List<ServiceEndpoint> get() {
        Access access = (Access)this.authInfo.get();
        ImmutableList.Builder serviceEndpoints = ImmutableList.builder();
        Iterator iterator = access.iterator();
        while (iterator.hasNext()) {
            Service service = (Service)((Object)iterator.next());
            Iterator iterator2 = service.iterator();
            while (iterator2.hasNext()) {
                Endpoint endpoint = (Endpoint)iterator2.next();
                if (endpoint.getAdminURL() != null) {
                    serviceEndpoints.add((Object)((ServiceEndpoint)this.toServiceEndpoint(service.getType(), ServiceEndpoint.Interface.ADMIN).apply((Object)endpoint)));
                }
                if (endpoint.getInternalURL() != null) {
                    serviceEndpoints.add((Object)((ServiceEndpoint)this.toServiceEndpoint(service.getType(), ServiceEndpoint.Interface.INTERNAL).apply((Object)endpoint)));
                }
                if (endpoint.getPublicURL() == null) continue;
                serviceEndpoints.add((Object)((ServiceEndpoint)this.toServiceEndpoint(service.getType(), ServiceEndpoint.Interface.PUBLIC).apply((Object)endpoint)));
            }
        }
        return serviceEndpoints.build();
    }

    private Function<Endpoint, ServiceEndpoint> toServiceEndpoint(final String type, final ServiceEndpoint.Interface iface) {
        return new Function<Endpoint, ServiceEndpoint>(){

            public ServiceEndpoint apply(Endpoint input) {
                ServiceEndpoint.Builder builder = ServiceEndpoint.builder().id(input.getId()).iface(iface).regionId(input.getRegion()).type(type).version(input.getVersionId());
                switch (iface) {
                    case ADMIN: {
                        builder.url(input.getAdminURL());
                        break;
                    }
                    case INTERNAL: {
                        builder.url(input.getInternalURL());
                        break;
                    }
                    case PUBLIC: {
                        builder.url(input.getPublicURL());
                        break;
                    }
                    case UNRECOGNIZED: {
                        URI url = input.getPublicURL() != null ? input.getPublicURL() : input.getInternalURL();
                        V2ServiceCatalog.this.logger.warn("Unrecognized endpoint interface for %s. Using URL: %s", new Object[]{input, url});
                        builder.url(url);
                    }
                }
                return builder.build();
            }
        };
    }
}

