/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.launcher.osgi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.core.mgmt.persist.ConfigLoader;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OsgiConfigLoader
implements ConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiConfigLoader.class);
    private static final List<String> EXCLUDED_KEYS = ImmutableList.of((Object)"service.pid", (Object)"felix.fileinstall.filename");
    private String propertiesPath;
    private ConfigurationAdmin configAdmin;

    public OsgiConfigLoader(String propertiesPath) {
        this.propertiesPath = propertiesPath;
        LOG.trace("OsgiConfigLoader instance created");
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public abstract void init();

    public abstract void destroy();

    public abstract void updateProperties(Map var1);

    public Map<String, String> load() {
        Configuration[] configs;
        if (this.configAdmin == null) {
            LOG.warn("No OSGi configuration-admin available - cannot load {}.cfg", (Object)this.propertiesPath);
            return ImmutableMap.of();
        }
        String filter = "(service.pid=" + this.propertiesPath + ')';
        try {
            configs = this.configAdmin.listConfigurations(filter);
        }
        catch (IOException | InvalidSyntaxException e) {
            LOG.info("Cannot list OSGi configurations");
            throw Exceptions.propagate((Throwable)e);
        }
        MutableMap map = MutableMap.of();
        if (configs != null) {
            for (Configuration config : configs) {
                LOG.debug("Reading OSGi configuration from {}; bundleLocation={}", (Object)config.getPid(), (Object)config.getBundleLocation());
                map.putAll(this.dictToMap(config.getProperties()));
            }
        } else {
            LOG.debug("No OSGi configuration found for {}.cfg; ignoring", (Object)this.propertiesPath);
        }
        return map;
    }

    private Map<String, String> dictToMap(Dictionary<String, Object> props) {
        MutableMap mapProps = MutableMap.of();
        Enumeration<String> keyEnum = props.keys();
        while (keyEnum.hasMoreElements()) {
            String key = keyEnum.nextElement();
            if (EXCLUDED_KEYS.contains(key)) continue;
            mapProps.put(key, (String)props.get(key));
        }
        return mapProps;
    }
}

