/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.input.InputStreamWithChannel;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientHolder;
import org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import org.apache.sshd.sftp.client.impl.SftpAckData;
import org.apache.sshd.sftp.common.SftpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpInputStreamAsync
extends InputStreamWithChannel
implements SftpClientHolder {
    protected final Logger log;
    protected final byte[] bb = new byte[1];
    protected final int bufferSize;
    protected final long fileSize;
    protected Buffer buffer;
    protected SftpClient.CloseableHandle handle;
    protected long requestOffset;
    protected long clientOffset;
    protected final Deque<SftpAckData> pendingReads = new LinkedList<SftpAckData>();
    protected boolean eofIndicator;
    private final AbstractSftpClient clientInstance;
    private final String path;

    public SftpInputStreamAsync(AbstractSftpClient client, int bufferSize, String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.clientInstance = Objects.requireNonNull(client, "No SFTP client instance");
        this.path = path;
        SftpClient.Attributes attrs = client.stat(path);
        this.fileSize = attrs.getSize();
        this.handle = client.open(path, mode);
        this.bufferSize = bufferSize;
    }

    public SftpInputStreamAsync(AbstractSftpClient client, int bufferSize, long clientOffset, long fileSize, String path, SftpClient.CloseableHandle handle) {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.clientInstance = Objects.requireNonNull(client, "No SFTP client instance");
        this.path = path;
        this.handle = handle;
        this.bufferSize = bufferSize;
        this.requestOffset = clientOffset;
        this.clientOffset = clientOffset;
        this.fileSize = fileSize;
    }

    @Override
    public final AbstractSftpClient getClient() {
        return this.clientInstance;
    }

    public final String getPath() {
        return this.path;
    }

    public boolean isEof() {
        return this.eofIndicator && this.hasNoData();
    }

    public boolean isOpen() {
        return this.handle != null && this.handle.isOpen();
    }

    public int read() throws IOException {
        int read = this.read(this.bb, 0, 1);
        if (read > 0) {
            return this.bb[0] & 0xFF;
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("read(" + this.getPath() + ") stream closed");
        }
        AtomicInteger offset = new AtomicInteger(off);
        int res = (int)this.doRead(len, buf -> {
            int l = buf.available();
            buf.getRawBytes(b, offset.getAndAdd(l), l);
        });
        if (res == 0 && this.eofIndicator) {
            res = -1;
        }
        return res;
    }

    public long transferTo(long len, WritableByteChannel out) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("transferTo(" + this.getPath() + ") stream closed");
        }
        long numXfered = this.doRead(len, buf -> {
            ByteBuffer bb = ByteBuffer.wrap(buf.array(), buf.rpos(), buf.available());
            while (bb.hasRemaining()) {
                out.write(bb);
            }
        });
        if (this.log.isDebugEnabled()) {
            this.log.debug("transferTo({}) transferred {}/{} bytes", new Object[]{this, numXfered, len});
        }
        return numXfered;
    }

    public long transferTo(OutputStream out) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("transferTo(" + this.getPath() + ") stream closed");
        }
        long numXfered = this.doRead(Long.MAX_VALUE, buf -> out.write(buf.array(), buf.rpos(), buf.available()));
        if (this.log.isDebugEnabled()) {
            this.log.debug("transferTo({}) transferred {} bytes", (Object)this, (Object)numXfered);
        }
        return numXfered;
    }

    private long doRead(long max, BufferConsumer consumer) throws IOException {
        long orgOffset = this.clientOffset;
        while (max > 0L) {
            if (this.hasNoData()) {
                if (this.eofIndicator) break;
                if (!this.pendingReads.isEmpty()) {
                    this.fillData();
                }
                if (this.eofIndicator) continue;
                this.sendRequests();
                continue;
            }
            int nb = (int)Math.min(max, (long)this.buffer.available());
            consumer.consume((Buffer)new ByteArrayBuffer(this.buffer.array(), this.buffer.rpos(), nb));
            this.buffer.rpos(this.buffer.rpos() + nb);
            this.clientOffset += (long)nb;
            max -= (long)nb;
        }
        return this.clientOffset - orgOffset;
    }

    public long skip(long n) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("skip(" + this.getPath() + ") stream closed");
        }
        if (this.clientOffset == 0L && this.pendingReads.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("skip({}) virtual skip of {} bytes", (Object)this, (Object)n);
            }
            this.requestOffset = n;
            this.clientOffset = n;
            return n;
        }
        return super.skip(n);
    }

    protected boolean hasNoData() {
        return this.buffer == null || this.buffer.available() == 0;
    }

    protected void sendRequests() throws IOException {
        AbstractSftpClient client = this.getClient();
        Channel channel = client.getChannel();
        Window localWindow = channel.getLocalWindow();
        long windowSize = localWindow.getMaxSize();
        ClientSession session = client.getSession();
        byte[] id = this.handle.getIdentifier();
        boolean traceEnabled = this.log.isTraceEnabled();
        if (this.fileSize > 0L && this.requestOffset > this.fileSize && !this.pendingReads.isEmpty()) {
            return;
        }
        while ((long)this.pendingReads.size() < Math.max(1L, windowSize / (long)this.bufferSize)) {
            Buffer buf = session.createBuffer((byte)94, 39 + id.length);
            buf.rpos(23);
            buf.wpos(23);
            buf.putBytes(id);
            buf.putLong(this.requestOffset);
            buf.putUInt((long)this.bufferSize);
            int reqId = client.send(5, buf);
            SftpAckData ack = new SftpAckData(reqId, this.requestOffset, this.bufferSize);
            if (traceEnabled) {
                this.log.trace("sendRequests({}) enqueue pending ack: {}", (Object)this, (Object)ack);
            }
            this.pendingReads.add(ack);
            this.requestOffset += (long)this.bufferSize;
            if (this.fileSize <= 0L || this.requestOffset <= this.fileSize) continue;
            break;
        }
    }

    protected void fillData() throws IOException {
        SftpAckData ack = this.pendingReads.pollFirst();
        boolean traceEnabled = this.log.isTraceEnabled();
        if (ack == null) {
            if (traceEnabled) {
                this.log.trace("fillData({}) no pending ack", (Object)this);
            }
            return;
        }
        if (traceEnabled) {
            this.log.trace("fillData({}) process ack={}", (Object)this, (Object)ack);
        }
        boolean alreadyEof = this.eofIndicator;
        this.pollBuffer(ack);
        if (!alreadyEof && this.clientOffset < ack.offset) {
            int cur;
            int dlen;
            byte[] data = new byte[(int)(ack.offset - this.clientOffset + (long)this.buffer.available())];
            int nb = (int)(ack.offset - this.clientOffset);
            if (traceEnabled) {
                this.log.trace("fillData({}) reading {} bytes", (Object)this, (Object)nb);
            }
            AtomicReference<Boolean> eof = new AtomicReference<Boolean>();
            AbstractSftpClient client = this.getClient();
            for (cur = 0; cur < nb; cur += dlen) {
                dlen = client.read(this.handle, this.clientOffset, data, cur, nb - cur, eof);
                Boolean eofSignal = eof.getAndSet(null);
                if (dlen >= 0 && (eofSignal == null || !eofSignal.booleanValue())) continue;
                this.eofIndicator = true;
                break;
            }
            if (traceEnabled) {
                this.log.trace("fillData({}) read {} bytes - EOF={}", new Object[]{this, cur, this.eofIndicator});
            }
            if (cur > 0) {
                this.buffer.getRawBytes(data, cur, this.buffer.available());
                this.buffer = new ByteArrayBuffer(data);
            } else {
                this.buffer.rpos(this.buffer.wpos());
            }
        }
    }

    protected void pollBuffer(SftpAckData ack) throws IOException {
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("pollBuffer({}) polling ack={}", (Object)this, (Object)ack);
        }
        AbstractSftpClient client = this.getClient();
        Buffer buf = client.receive(ack.id);
        int length = buf.getInt();
        int type = buf.getUByte();
        int id = buf.getInt();
        if (traceEnabled) {
            this.log.trace("pollBuffer({}) response={} for ack={} - len={}", new Object[]{this, type, ack, length});
        }
        client.validateIncomingResponse(94, id, type, length, buf);
        if (type == 103) {
            int dlen = buf.getInt();
            int rpos = buf.rpos();
            buf.rpos(rpos + dlen);
            Boolean b = SftpHelper.getEndOfFileIndicatorValue(buf, client.getVersion());
            if (b != null && b.booleanValue()) {
                this.eofIndicator = true;
            }
            buf.rpos(rpos);
            buf.wpos(rpos + dlen);
            this.buffer = buf;
        } else if (type == 101) {
            int substatus = buf.getInt();
            String msg = buf.getString();
            String lang = buf.getString();
            if (substatus == 1) {
                this.eofIndicator = true;
            } else {
                client.checkResponseStatus(94, id, substatus, msg, lang);
            }
        } else {
            IOException err = client.handleUnexpectedPacket(94, 101, id, type, length, buf);
            if (err != null) {
                throw err;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            try {
                int ackIndex = 1;
                while (!this.pendingReads.isEmpty()) {
                    SftpAckData ack = this.pendingReads.removeFirst();
                    if (debugEnabled) {
                        this.log.debug("close({}) process ack #{}: {}", new Object[]{this, ackIndex, ack});
                    }
                    this.pollBuffer(ack);
                    ++ackIndex;
                }
            }
            finally {
                if (debugEnabled) {
                    this.log.debug("close({}) closing file handle", (Object)this);
                }
                this.handle.close();
            }
        }
        finally {
            this.handle = null;
        }
    }

    public String toString() {
        AbstractSftpClient client = this.getClient();
        return this.getClass().getSimpleName() + "[" + client.getSession() + "][" + this.getPath() + "]";
    }

    static interface BufferConsumer {
        public void consume(Buffer var1) throws IOException;
    }
}

