/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.entity.docker;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.container.entity.docker.DockerContainer;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.network.OnPublicNetworkEnricher;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.software.base.EmptySoftwareProcessImpl;
import org.apache.brooklyn.util.collections.MutableList;

public class DockerContainerImpl
extends EmptySoftwareProcessImpl
implements DockerContainer {
    public void init() {
        super.init();
        String imageName = (String)this.config().get(DockerContainer.IMAGE_NAME);
        if (!Strings.isNullOrEmpty((String)imageName)) {
            this.config().set(PROVISIONING_PROPERTIES.subKey("imageId"), (Object)imageName);
        }
        if (Boolean.TRUE.equals(this.config().get(DockerContainer.DISABLE_SSH))) {
            this.config().set(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION, (Object)true);
            this.config().set(PROVISIONING_PROPERTIES.subKey("useJcloudsSshInit"), (Object)false);
            this.config().set(PROVISIONING_PROPERTIES.subKey("waitForSshable"), (Object)false);
            this.config().set(PROVISIONING_PROPERTIES.subKey("pollForFirstReachableAddress"), (Object)false);
            this.config().set(EmptySoftwareProcessImpl.USE_SSH_MONITORING, (Object)false);
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        MutableList portRanges = MutableList.copyOf((Iterable)((Iterable)this.config().get(DockerContainer.INBOUND_TCP_PORTS)));
        for (String portRange : portRanges) {
            for (Integer port : PortRanges.fromString((String)portRange)) {
                AttributeSensor element = Sensors.newIntegerSensor((String)("docker.port." + port));
                this.sensors().set(element, (Object)port);
                builder.add((Object)element);
            }
        }
        this.enrichers().add((EnricherSpec)EnricherSpec.create(OnPublicNetworkEnricher.class).configure(OnPublicNetworkEnricher.SENSORS, (Object)builder.build()));
    }

    protected void disconnectSensors() {
        if (this.isSshMonitoringEnabled()) {
            this.disconnectServiceUpIsRunning();
        }
        super.disconnectSensors();
    }

    protected void connectSensors() {
        super.connectSensors();
        if (this.isSshMonitoringEnabled()) {
            this.connectServiceUpIsRunning();
        } else {
            this.sensors().set(Attributes.SERVICE_UP, (Object)true);
        }
    }
}

