/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.container.location.kubernetes;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.jclouds.compute.domain.OsFamily;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageChooser {
    private static final Logger LOG = LoggerFactory.getLogger(ImageChooser.class);
    private static final List<ImageMetadata> DEFAULT_IMAGES = ImmutableList.of((Object)new ImageMetadata(OsFamily.CENTOS, "7", "brooklyncentral/centos:7"), (Object)new ImageMetadata(OsFamily.UBUNTU, "14.04", "brooklyncentral/ubuntu:14.04"), (Object)new ImageMetadata(OsFamily.UBUNTU, "16.04", "brooklyncentral/ubuntu:16.04"), (Object)new ImageMetadata(OsFamily.UBUNTU, "18.04", "brooklyncentral/ubuntu:18.04"));
    private final List<ImageMetadata> images;

    public ImageChooser() {
        this.images = DEFAULT_IMAGES;
    }

    public ImageChooser(List<? extends ImageMetadata> images) {
        this.images = ImmutableList.copyOf(images);
    }

    public Optional<String> chooseImage(String osFamily, String osVersionRegex) {
        return this.chooseImage(osFamily == null ? (OsFamily)null : OsFamily.fromValue((String)osFamily), osVersionRegex);
    }

    public Optional<String> chooseImage(OsFamily osFamily, String osVersionRegex) {
        for (ImageMetadata imageMetadata : this.images) {
            if (!imageMetadata.matches(osFamily, osVersionRegex)) continue;
            String imageName = imageMetadata.getImageName();
            LOG.debug("Choosing container image {}, for osFamily={} and osVersionRegex={}", new Object[]{imageName, osFamily, osVersionRegex});
            return Optional.of((Object)imageName);
        }
        return Optional.absent();
    }

    public static class ImageMetadata {
        private final OsFamily osFamily;
        private final String osVersion;
        private final String imageName;

        public ImageMetadata(OsFamily osFamily, String osVersion, String imageName) {
            this.osFamily = (OsFamily)Preconditions.checkNotNull((Object)osFamily, (Object)"osFamily");
            this.osVersion = (String)Preconditions.checkNotNull((Object)osVersion, (Object)"osVersion");
            this.imageName = (String)Preconditions.checkNotNull((Object)imageName, (Object)"imageName");
        }

        public boolean matches(@Nullable OsFamily osFamily, @Nullable String osVersionRegex) {
            if (osFamily != null && osFamily != this.osFamily) {
                return false;
            }
            return osVersionRegex == null || this.osVersion.matches(osVersionRegex);
        }

        public String getImageName() {
            return this.imageName;
        }
    }
}

