/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.proxy.nginx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.trait.Changeable;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.group.AbstractGroupImpl;
import org.apache.brooklyn.entity.proxy.ProxySslConfig;
import org.apache.brooklyn.entity.proxy.nginx.UrlMapping;
import org.apache.brooklyn.entity.proxy.nginx.UrlRewriteRule;
import org.apache.brooklyn.entity.webapp.WebAppServiceConstants;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlMappingImpl
extends AbstractGroupImpl
implements UrlMapping {
    private static final Logger log = LoggerFactory.getLogger(UrlMapping.class);
    private SubscriptionHandle subscriptionHandle;
    private SubscriptionHandle subscriptionHandle2;

    @Override
    public String getUniqueLabel() {
        String l = (String)this.getConfig(LABEL);
        if (JavaGroovyEquivalents.groovyTruth((String)l)) {
            return this.getId() + "-" + l;
        }
        return this.getId();
    }

    @Override
    public synchronized UrlMapping addRewrite(String from, String to) {
        return this.addRewrite(new UrlRewriteRule(from, to));
    }

    @Override
    public synchronized UrlMapping addRewrite(UrlRewriteRule rule) {
        ArrayList<UrlRewriteRule> rewrites = (ArrayList<UrlRewriteRule>)this.getConfig(REWRITES);
        if (rewrites == null) {
            rewrites = new ArrayList<UrlRewriteRule>();
        }
        rewrites.add(rule);
        this.config().set(REWRITES, rewrites);
        return this;
    }

    @Override
    public String getDomain() {
        return (String)Preconditions.checkNotNull((Object)this.getConfig(DOMAIN), (Object)"domain config argument required");
    }

    @Override
    public String getPath() {
        return (String)this.getConfig(PATH);
    }

    @Override
    public Entity getTarget() {
        return (Entity)this.getConfig(TARGET_PARENT);
    }

    @Override
    public void setTarget(Entity target) {
        this.config().set(TARGET_PARENT, (Object)target);
        this.recompute();
    }

    public void onManagementStarting() {
        super.onManagementStarting();
        if (this.getConfig(TARGET_PARENT) != null) {
            this.recompute();
        }
    }

    protected String getAddressOfEntity(Entity s) {
        String h = (String)s.getAttribute(Attributes.HOSTNAME);
        Integer p = null;
        Set protos = (Set)s.getAttribute(WebAppServiceConstants.ENABLED_PROTOCOLS);
        ProxySslConfig sslConfig = (ProxySslConfig)this.getConfig(SSL_CONFIG);
        if (sslConfig != null && sslConfig.getTargetIsSsl()) {
            if (protos == null || !this.hasProtocol(protos, "https")) {
                log.warn("Misconfiguration for " + this + ": ENABLED_PROTOCOLS='" + protos + "' for " + s + " but sslConfig=" + sslConfig);
            }
            p = (Integer)s.getAttribute((AttributeSensor)Attributes.HTTPS_PORT);
            if (p == null) {
                log.warn("Misconfiguration for " + this + ": sslConfig=" + sslConfig + " but no HTTPS_PORT on " + s);
            }
        }
        if (p == null) {
            p = (Integer)s.getAttribute((AttributeSensor)Attributes.HTTP_PORT);
        }
        if (JavaGroovyEquivalents.groovyTruth((String)h) && p != null) {
            return h + ":" + p;
        }
        log.error("Unable to construct hostname:port representation for " + s + "; skipping in " + this);
        return null;
    }

    protected synchronized void recomputeAddresses() {
        LinkedHashSet resultM = Sets.newLinkedHashSet();
        for (Entity s : this.getMembers()) {
            String hp = this.getAddressOfEntity(s);
            if (hp == null) continue;
            resultM.add(hp);
        }
        Set result = Collections.unmodifiableSet(resultM);
        Collection oldAddresses = (Collection)this.getAttribute(TARGET_ADDRESSES);
        if (oldAddresses == null || !result.equals(ImmutableSet.copyOf((Collection)oldAddresses))) {
            this.sensors().set(TARGET_ADDRESSES, result);
        }
    }

    @Override
    public Collection<String> getTargetAddresses() {
        return (Collection)this.getAttribute(TARGET_ADDRESSES);
    }

    @Override
    public ProxySslConfig getSsl() {
        return (ProxySslConfig)this.getConfig(SSL_CONFIG);
    }

    protected SubscriptionHandle getSubscriptionHandle() {
        return this.subscriptionHandle;
    }

    @Override
    public synchronized void recompute() {
        Entity t;
        if (this.subscriptionHandle != null) {
            this.subscriptions().unsubscribe(this.subscriptionHandle);
        }
        if (this.subscriptionHandle2 != null) {
            this.subscriptions().unsubscribe(this.subscriptionHandle2);
        }
        if ((t = this.getTarget()) != null) {
            this.subscriptionHandle = this.subscriptions().subscribeToChildren(t, (Sensor)Startable.SERVICE_UP, (SensorEventListener)new SensorEventListener<Boolean>(){

                public void onEvent(SensorEvent<Boolean> event) {
                    boolean changed;
                    boolean bl = changed = (Boolean)event.getValue() != false ? UrlMappingImpl.this.addMember(event.getSource()) : UrlMappingImpl.this.removeMember(event.getSource());
                    if (changed) {
                        UrlMappingImpl.this.recomputeAddresses();
                    }
                }
            });
            this.subscriptionHandle2 = this.subscriptions().subscribe(t, (Sensor)Changeable.MEMBER_REMOVED, (SensorEventListener)new SensorEventListener<Entity>(){

                public void onEvent(SensorEvent<Entity> event) {
                    UrlMappingImpl.this.removeMember((Entity)event.getValue());
                    UrlMappingImpl.this.recomputeAddresses();
                }
            });
            this.setMembers(t.getChildren(), EntityPredicates.attributeEqualTo((AttributeSensor)Startable.SERVICE_UP, (Object)true));
        }
        this.recomputeAddresses();
    }

    @Override
    public void discard() {
        Entities.unmanage((Entity)this);
    }

    private boolean hasProtocol(Collection<String> protocols, String desired) {
        for (String contender : protocols) {
            if (!"https".equals(contender.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

