/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.net;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Networking {
    private static final Logger log = LoggerFactory.getLogger(Networking.class);
    public static final int MIN_PORT_NUMBER = 1;
    public static final int MAX_PORT_NUMBER = 65535;
    public static final Boolean SET_REUSE_ADDRESS = false;
    public static final String VALID_IP_ADDRESS_REGEX = "^((0*[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}(0*[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
    public static final Pattern VALID_IP_ADDRESS_PATTERN = Pattern.compile("^((0*[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}(0*[0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    public static final List<Cidr> PRIVATE_NETWORKS = Cidr.PRIVATE_NETWORKS_RFC_1918;
    public static InetAddress ANY_NIC = Networking.getInetAddressWithFixedName(0, 0, 0, 0);
    public static InetAddress LOOPBACK = Networking.getInetAddressWithFixedName(127, 0, 0, 1);
    private static boolean triedUnresolvableHostname = false;
    private static String cachedAddressOfUnresolvableHostname = null;

    public static boolean isPortAvailable(int port) {
        return Networking.isPortAvailable(ANY_NIC, port);
    }

    public static boolean isPortAvailable(InetAddress localAddress, int port) {
        return Networking.isPortAvailable(localAddress, port, SET_REUSE_ADDRESS);
    }

    /*
     * Exception decompiling
     */
    public static boolean isPortAvailable(InetAddress localAddress, int port, Boolean allowReuse) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAddressValid(InetAddress addr) {
        ServerSocket ss;
        try {
            ss = new ServerSocket();
            ss.setSoTimeout(250);
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
        try {
            ss.bind(new InetSocketAddress(addr, 0));
            boolean e = true;
            return e;
        }
        catch (IOException e) {
            if (log.isTraceEnabled()) {
                log.trace("Binding on {} failed, interface could be down, being reconfigured, file handle exhaustion, port exhaustion, etc.", (Object)addr);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Networking.closeQuietly(ss);
        }
    }

    public static int nextAvailablePort(int port) {
        Preconditions.checkArgument((port >= 1 && port <= 65535 ? 1 : 0) != 0, (String)"requested port %s is outside the valid range of %s to %s", (Object)port, (Object)1, (Object)65535);
        int originalPort = port;
        while (!Networking.isPortAvailable(port) && port < 65535) {
            ++port;
        }
        if (port >= 65535) {
            throw new RuntimeException("unable to find a free port at or above " + originalPort);
        }
        return port;
    }

    public static boolean isPortValid(Integer port) {
        return port != null && port >= 1 && port <= 65535;
    }

    public static int checkPortValid(Integer port, String errorMessage) {
        if (!Networking.isPortValid(port)) {
            throw new IllegalArgumentException("Invalid port value " + port + ": " + errorMessage);
        }
        return port;
    }

    public static void checkPortsValid(Map<?, ?> ports) {
        for (Map.Entry<?, ?> entry : ports.entrySet()) {
            Object val = entry.getValue();
            if (val == null) {
                throw new IllegalArgumentException("port for " + entry.getKey() + " is null");
            }
            if (!(val instanceof Integer)) {
                throw new IllegalArgumentException("port " + val + " for " + entry.getKey() + " is not an integer (" + val.getClass() + ")");
            }
            Networking.checkPortValid((Integer)val, "" + entry.getKey());
        }
    }

    public static RangeSet<Integer> portRulesToRanges(Collection<String> portRules) {
        TreeRangeSet result = TreeRangeSet.create();
        for (String portRule : portRules) {
            if (portRule.contains("-")) {
                String[] fromTo = portRule.split("-");
                Preconditions.checkArgument((fromTo.length == 2 ? 1 : 0) != 0, (String)"Invalid port range '%s'", (Object)portRule);
                Preconditions.checkArgument((Strings.countOccurrences(portRule, '-') == 1 ? 1 : 0) != 0, (String)"Invalid port range '%s'", (Object)portRule);
                Preconditions.checkArgument((boolean)Strings.isNonEmpty(fromTo[0]), (String)"Invalid port range '%s'", (Object)portRule);
                Preconditions.checkArgument((boolean)Strings.isNonEmpty(fromTo[1]), (String)"Invalid port range '%s'", (Object)portRule);
                result.add(Networking.closedRange(fromTo[0], fromTo[1]));
                continue;
            }
            result.add(Networking.closedRange(portRule, portRule));
        }
        return result;
    }

    private static Range<Integer> closedRange(String from, String to) {
        Integer fromPort = Integer.parseInt(from);
        Integer toPort = Integer.parseInt(to);
        Preconditions.checkArgument((boolean)Networking.isPortValid(fromPort), (String)"fromPort %s should be a number between %s and %s", (Object)fromPort, (Object)1, (Object)65535);
        Preconditions.checkArgument((boolean)Networking.isPortValid(toPort), (String)"toPort %s should be a number between %s and %s", (Object)toPort, (Object)1, (Object)65535);
        Preconditions.checkArgument((fromPort <= toPort ? 1 : 0) != 0, (String)"fromPort %s should be less than or equal to toPort %s", (Object)fromPort, (Object)toPort);
        return Range.closed((Comparable)fromPort, (Comparable)toPort);
    }

    public static boolean isPrivateSubnet(InetAddress address) {
        return address.isSiteLocalAddress() || address.isLoopbackAddress() || address.isLinkLocalAddress();
    }

    public static boolean isLocalOnly(InetAddress address) {
        return address.isLoopbackAddress() || address.isLinkLocalAddress();
    }

    public static boolean isLocalOnly(String hostnameOrIp) {
        Preconditions.checkNotNull((Object)hostnameOrIp, (Object)"hostnameOrIp");
        if ("127.0.0.1".equals(hostnameOrIp)) {
            return true;
        }
        if ("localhost".equals(hostnameOrIp)) {
            return true;
        }
        if ("localhost.localdomain".equals(hostnameOrIp)) {
            return true;
        }
        try {
            InetAddress ia = Networking.getInetAddressWithFixedName(hostnameOrIp);
            return Networking.isLocalOnly(ia);
        }
        catch (Exception e) {
            log.debug("Networking cannot resolve " + hostnameOrIp + ": assuming it is not a local-only address, but it is a private address");
            return false;
        }
    }

    public static boolean isPrivateSubnet(String hostnameOrIp) {
        Preconditions.checkNotNull((Object)hostnameOrIp, (Object)"hostnameOrIp");
        try {
            InetAddress ia = Networking.getInetAddressWithFixedName(hostnameOrIp);
            return Networking.isPrivateSubnet(ia);
        }
        catch (Exception e) {
            log.debug("Networking cannot resolve " + hostnameOrIp + ": assuming it IS a private address");
            return true;
        }
    }

    public static synchronized String getAddressOfUnresolvableHostname() {
        if (triedUnresolvableHostname) {
            return cachedAddressOfUnresolvableHostname;
        }
        String h = "noexistent-machine-" + Identifiers.makeRandomBase64Id(8);
        try {
            cachedAddressOfUnresolvableHostname = InetAddress.getByName(h).getHostAddress();
            log.info("Networking detected " + cachedAddressOfUnresolvableHostname + " being returned by DNS for bogus hostnames (" + h + ")");
        }
        catch (Exception e) {
            log.debug("Networking detected failure on DNS resolution of unknown hostname (" + h + " throws " + e + ")");
            cachedAddressOfUnresolvableHostname = null;
        }
        triedUnresolvableHostname = true;
        return cachedAddressOfUnresolvableHostname;
    }

    public static InetAddress resolve(String hostname) {
        try {
            InetAddress a = InetAddress.getByName(hostname);
            if (a == null) {
                return null;
            }
            String ha = a.getHostAddress();
            if (log.isDebugEnabled()) {
                log.debug("Networking resolved " + hostname + " as " + a);
            }
            if (ha.equals(Networking.getAddressOfUnresolvableHostname())) {
                return null;
            }
            if (ha.startsWith("169.")) {
                return null;
            }
            return a;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Networking failed to resolve " + hostname + ", threw " + e);
            }
            return null;
        }
    }

    public static InetAddress getInetAddressWithFixedName(byte[] ip) {
        try {
            StringBuilder name = new StringBuilder();
            for (byte part : ip) {
                if (name.length() > 0) {
                    name.append(".");
                }
                name.append(UnsignedBytes.toString((byte)part));
            }
            return InetAddress.getByAddress(name.toString(), ip);
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static InetAddress getInetAddressWithFixedName(int ip1, int ip2, int ip3, int ip4) {
        return Networking.getInetAddressWithFixedName(Networking.asByteArray(ip1, ip2, ip3, ip4));
    }

    public static InetAddress getInetAddressWithFixedName(int ip1, int ip2, int ip3, int ip4, int ip5, int ip6) {
        return Networking.getInetAddressWithFixedName(Networking.asByteArray(ip1, ip2, ip3, ip4, ip5, ip6));
    }

    public static byte[] asByteArray(long ... bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = UnsignedBytes.checkedCast((long)bytes[i]);
        }
        return result;
    }

    public static boolean isValidIp4(String input) {
        return VALID_IP_ADDRESS_PATTERN.matcher(input).matches();
    }

    public static InetAddress getInetAddressWithFixedName(String hostnameOrIp) {
        try {
            if (Networking.isValidIp4(hostnameOrIp)) {
                byte[] ip = new byte[4];
                Object[] parts = hostnameOrIp.split("\\.");
                assert (parts.length == 4) : "val=" + hostnameOrIp + "; split=" + Arrays.toString(parts) + "; length=" + parts.length;
                for (int i = 0; i < parts.length; ++i) {
                    ip[i] = UnsignedBytes.parseUnsignedByte((String)parts[i]);
                }
                return InetAddress.getByAddress(hostnameOrIp, ip);
            }
            return InetAddress.getByName(hostnameOrIp);
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static InetAddress getLocalHost() {
        return Networking.getLocalHost(false, true, true, false, 0);
    }

    public static InetAddress getReachableLocalHost() {
        return Networking.getLocalHost(true, true, true, true, 250);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InetAddress getLocalHost(boolean checkReachable, boolean prefer127, boolean preferIpV4, boolean failIfNone, int timeout) {
        InetAddress result;
        Map<String, InetAddress> addrs = Networking.getLocalAddresses();
        MutableSet<InetAddress> candidates = new MutableSet<InetAddress>();
        if (prefer127) {
            candidates.addIfNotNull(addrs.get("127.0.0.1"));
        }
        if (preferIpV4) {
            candidates.addAll(Iterables.filter(addrs.values(), Inet4Address.class));
        }
        ((AbstractCollection)candidates).addAll(addrs.values());
        if (!checkReachable) {
            if (!candidates.isEmpty()) {
                return (InetAddress)candidates.iterator().next();
            }
        } else {
            for (InetAddress a : candidates) {
                try {
                    ServerSocket ss = new ServerSocket();
                    Throwable throwable = null;
                    try {
                        ss.bind(new InetSocketAddress(a, 0));
                        if (!Networking.isReachable(HostAndPort.fromParts((String)a.getHostAddress(), (int)ss.getLocalPort()), true, timeout)) continue;
                        InetAddress inetAddress = a;
                        return inetAddress;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (ss == null) continue;
                        if (throwable != null) {
                            try {
                                ss.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        ss.close();
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal(e);
                }
            }
        }
        if (failIfNone) {
            throw new IllegalStateException("No reachable local addresses could be found; ensure that localhost is correctly configured on this machine, and if required that network security permits local access to localhost ports");
        }
        try {
            result = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e2) {
            result = Networking.getInetAddressWithFixedName("127.0.0.1");
        }
        log.warn("Localhost is not resolvable; using " + result);
        return result;
    }

    public static Map<String, InetAddress> getLocalAddresses() {
        Enumeration<NetworkInterface> ne;
        LinkedHashMap<String, InetAddress> result = new LinkedHashMap<String, InetAddress>();
        try {
            ne = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.warn("Local network interfaces are not resolvable: " + e);
            ne = null;
        }
        while (ne != null && ne.hasMoreElements()) {
            NetworkInterface nic = ne.nextElement();
            Enumeration<InetAddress> inets = nic.getInetAddresses();
            while (inets.hasMoreElements()) {
                InetAddress inet = inets.nextElement();
                result.put(inet.getHostAddress(), inet);
            }
        }
        if (result.isEmpty()) {
            log.warn("No local network addresses found; assuming 127.0.0.1");
            InetAddress loop = Cidr.LOOPBACK.addressAtOffset(0);
            result.put(loop.getHostAddress(), loop);
        }
        return result;
    }

    public static Cidr cidr(String cidr) {
        return new Cidr(cidr);
    }

    public static Cidr getPrivateNetwork(String ip) {
        Cidr me = new Cidr(ip + "/32");
        for (Cidr c : PRIVATE_NETWORKS) {
            if (!c.contains(me)) continue;
            return c;
        }
        return me;
    }

    public static Cidr getPrivateNetwork(InetAddress address) {
        return Networking.getPrivateNetwork(address.getHostAddress());
    }

    public static boolean isPublicIp(String ipAddress) {
        Cidr me = new Cidr(ipAddress + "/32");
        for (Cidr c : Cidr.NON_PUBLIC_CIDRS) {
            if (!c.contains(me)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLocalhost(String remoteAddress) {
        Map<String, InetAddress> addresses = Networking.getLocalAddresses();
        if (addresses.containsKey(remoteAddress)) {
            return true;
        }
        if ("127.0.0.1".equals(remoteAddress)) {
            return true;
        }
        String modifiedIpV6Address = remoteAddress;
        if (modifiedIpV6Address.contains("%")) {
            modifiedIpV6Address = modifiedIpV6Address.substring(0, modifiedIpV6Address.indexOf("%"));
        }
        if ("0:0:0:0:0:0:0:1".equals(modifiedIpV6Address)) {
            return true;
        }
        if ("::1".equals(modifiedIpV6Address)) {
            return true;
        }
        if (addresses.containsKey(remoteAddress) || addresses.containsKey(modifiedIpV6Address)) {
            return true;
        }
        try {
            InetAddress remote = InetAddress.getByName(remoteAddress);
            if (addresses.values().contains(remote)) {
                return true;
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal(e);
            log.debug("Error resolving address " + remoteAddress + " when checking if it is local (assuming not: " + e, (Throwable)e);
        }
        return false;
    }

    public static boolean isReachable(HostAndPort endpoint) {
        return Networking.isReachable(endpoint, false, 0);
    }

    public static boolean isReachable(HostAndPort endpoint, boolean noReuseOrLinger, int timeout) {
        try {
            Socket s = new Socket();
            if (noReuseOrLinger) {
                s.setReuseAddress(false);
                s.setSoLinger(false, 1);
            }
            if (timeout > 0) {
                s.setSoTimeout(timeout);
            }
            s.connect(new InetSocketAddress(endpoint.getHost(), endpoint.getPort()), timeout);
            Networking.closeQuietly(s);
            return true;
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Error reaching " + endpoint + " during reachability check (return false)", (Throwable)e);
            }
            return false;
        }
    }

    public static Predicate<HostAndPort> isReachablePredicate() {
        return new IsReachablePredicate();
    }

    public static void closeQuietly(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ServerSocket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(DatagramSocket s) {
        if (s != null) {
            s.close();
        }
    }

    public static void installTlsOnlyForHttpsForcing() {
        System.setProperty("https.protocols", "TLSv1");
    }

    public static void installTlsForHttpsIfAppropriate() {
        if (System.getProperty("https.protocols") == null && System.getProperty("brooklyn.https.protocols.leave_untouched") == null) {
            Networking.installTlsOnlyForHttpsForcing();
        }
    }

    public static void init() {
    }

    static {
        Networking.installTlsForHttpsIfAppropriate();
    }

    public static class IsReachablePredicate
    implements Predicate<HostAndPort> {
        public boolean apply(HostAndPort input) {
            return Networking.isReachable(input);
        }
    }
}

