/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.osgi;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.text.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class OsgiUtils {
    public static URL getContainerUrl(URL url, String resourceInThatDir) {
        boolean isJar = "jar".equals(url.getProtocol());
        if (isJar) {
            try {
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                url = connection.getJarFileURL();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        String path = url.toString();
        int i = path.indexOf(resourceInThatDir);
        if (i == -1) {
            throw new IllegalStateException("Resource path (" + resourceInThatDir + ") not in url substring (" + url + ")");
        }
        String parent = path.substring(0, i);
        try {
            url = new URL(parent);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Resource (" + resourceInThatDir + ") found at invalid URL parent (" + parent + ")", e);
        }
        return url;
    }

    public static String getVersionedId(Manifest manifest) {
        Attributes atts = manifest.getMainAttributes();
        return atts.getValue("Bundle-SymbolicName") + ":" + atts.getValue("Bundle-Version");
    }

    public static String getVersionedId(Bundle b) {
        return b.getSymbolicName() + ":" + b.getVersion();
    }

    @Deprecated
    public static Maybe<VersionedName> parseOsgiIdentifier(String symbolicNameOptionalWithVersion) {
        if (Strings.isBlank(symbolicNameOptionalWithVersion)) {
            return Maybe.absent("OSGi identifier is blank");
        }
        String[] parts = symbolicNameOptionalWithVersion.split(":");
        if (parts.length > 2) {
            return Maybe.absent("OSGi identifier has too many parts; max one ':' symbol");
        }
        Version v = null;
        if (parts.length == 2) {
            try {
                v = Version.parseVersion((String)parts[1]);
            }
            catch (IllegalArgumentException e) {
                return Maybe.absent("OSGi identifier has invalid version string (" + e.getMessage() + ")");
            }
        }
        return Maybe.of(new VersionedName(parts[0], v));
    }

    public static String toOsgiVersion(String version) {
        if (version != null) {
            return DefaultMaven2OsgiConverter.cleanupVersion(version);
        }
        return null;
    }

    private static class DefaultMaven2OsgiConverter {
        static final Pattern FUZZY_VERSION = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);

        private DefaultMaven2OsgiConverter() {
        }

        public static String cleanupVersion(String version) {
            StringBuffer result = new StringBuffer();
            Matcher m = FUZZY_VERSION.matcher(version);
            if (m.matches()) {
                String major = m.group(1);
                String minor = m.group(3);
                String micro = m.group(5);
                String qualifier = m.group(7);
                if (major != null) {
                    result.append(major);
                    if (minor != null) {
                        result.append(".");
                        result.append(minor);
                        if (micro != null) {
                            result.append(".");
                            result.append(micro);
                            if (qualifier != null) {
                                result.append(".");
                                DefaultMaven2OsgiConverter.cleanupModifier(result, qualifier);
                            }
                        } else if (qualifier != null) {
                            result.append(".0.");
                            DefaultMaven2OsgiConverter.cleanupModifier(result, qualifier);
                        } else {
                            result.append(".0");
                        }
                    } else if (qualifier != null) {
                        result.append(".0.0.");
                        DefaultMaven2OsgiConverter.cleanupModifier(result, qualifier);
                    } else {
                        result.append(".0.0");
                    }
                }
            } else {
                result.append("0.0.0.");
                DefaultMaven2OsgiConverter.cleanupModifier(result, version);
            }
            return result.toString();
        }

        static void cleanupModifier(StringBuffer result, String modifier) {
            for (int i = 0; i < modifier.length(); ++i) {
                char c = modifier.charAt(i);
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                    result.append(c);
                    continue;
                }
                result.append('_');
            }
        }
    }
}

