/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.rest.domain.BundleInstallationRestResult;
import org.apache.brooklyn.rest.domain.BundleSummary;
import org.apache.brooklyn.rest.domain.TypeDetail;
import org.apache.brooklyn.rest.domain.TypeSummary;

@Path(value="/catalog/bundles")
@Api(value="Catalog Bundles")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface BundleApi {
    @GET
    @ApiOperation(value="List bundles registered in the system including their types", response=BundleSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<BundleSummary> list(@ApiParam(name="versions", value="Whether to list 'latest' for each symbolic-name or 'all' versions", required=false, defaultValue="latest") @QueryParam(value="versions") String var1, @ApiParam(name="detail", value="Whether to include types and other detail info, default 'false'", required=false, defaultValue="false") @QueryParam(value="detail") boolean var2);

    @Path(value="/{symbolicName}")
    @GET
    @ApiOperation(value="Get summaries for all versions of the given bundle, with more recent ones first (preferring non-SNAPSHOTs)", response=BundleSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Symbolic name not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<BundleSummary> listVersions(@ApiParam(name="symbolicName", value="Bundle name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="detail", value="Whether to include types and other detail info, default 'false'", required=false, defaultValue="false") @QueryParam(value="detail") boolean var2);

    @Path(value="/{symbolicName}/{version}")
    @GET
    @ApiOperation(value="Get detail on a specific bundle given its symbolic name and version", response=BundleSummary.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Symbolic name not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public BundleSummary detail(@ApiParam(name="symbolicName", value="Bundle name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="Version to query", required=true) @PathParam(value="version") String var2);

    @Path(value="/{symbolicName}/{version}/download")
    @GET
    @ApiOperation(value="Download a ZIP archive of a specific bundle given its symbolic name and version")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Cannot find Zip archive or bundle"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response download(@ApiParam(name="symbolicName", value="Bundle name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="Version to query", required=true) @PathParam(value="version") String var2);

    @Path(value="/{symbolicName}/{version}/types")
    @GET
    @ApiOperation(value="Get all types declared in a given bundle", response=TypeDetail.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Symbolic name not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<TypeSummary> getTypes(@ApiParam(name="symbolicName", value="Bundle name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="Version of bundle and of type to query", required=true) @PathParam(value="version") String var2);

    @Path(value="/{symbolicName}/{version}/types/{typeSymbolicName}")
    @GET
    @ApiOperation(value="Get detail on a given type in a given bundle", response=TypeDetail.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Symbolic name or type not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public TypeDetail getType(@ApiParam(name="symbolicName", value="Bundle name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="Version of bundle and of type to query", required=true) @PathParam(value="version") String var2, @ApiParam(name="typeSymbolicName", value="Type name to query", required=true) @PathParam(value="typeSymbolicName") String var3);

    @Path(value="/{symbolicName}/{version}/types/{typeSymbolicName}/{typeVersion}")
    @GET
    @ApiOperation(value="Get detail on a given type and version in a bundle (special method for unusual cases where type has different version)", response=TypeDetail.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Symbolic name, type or version not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public TypeDetail getTypeExplicitVersion(@ApiParam(name="symbolicName", value="Bundle name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="Bundle version to query", required=true) @PathParam(value="version") String var2, @ApiParam(name="typeSymbolicName", value="Type name to query", required=true) @PathParam(value="typeSymbolicName") String var3, @ApiParam(name="typeVersion", value="Version to query (if different to bundle version)", required=true) @PathParam(value="typeVersion") String var4);

    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Symbolic name, type or version not found"), @ApiResponse(code=500, message="Internal Server Error")})
    @Path(value="/{symbolicName}/{version}/types/{typeSymbolicName}/{typeVersion}/icon")
    @GET
    @ApiOperation(value="Returns the icon image registered for this type")
    @Produces(value={"application/image"})
    public Response getTypeExplicitVersionIcon(@ApiParam(name="symbolicName", value="Bundle name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="Bundle version to query", required=true) @PathParam(value="version") String var2, @ApiParam(name="typeSymbolicName", value="Type name to query", required=true) @PathParam(value="typeSymbolicName") String var3, @ApiParam(name="typeVersion", value="Version to query (if different to bundle version, or * or empty)", required=true) @PathParam(value="typeVersion") String var4);

    @Path(value="/{symbolicName}/{version}")
    @DELETE
    @ApiOperation(value="Removes a bundle, unregistering all the types it declares", response=BundleInstallationRestResult.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Symbolic name, type, or version not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public BundleInstallationRestResult remove(@ApiParam(name="symbolicName", value="Bundle name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="Version to query", required=true) @PathParam(value="version") String var2, @ApiParam(name="force", value="Whether to forcibly remove it, even if in use and/or errors", required=false, defaultValue="false") @QueryParam(value="force") @DefaultValue(value="false") Boolean var3);

    @Deprecated
    @POST
    @Consumes(value={"application/deprecated-yaml"})
    @ApiOperation(value="(deprecated; use same endpoint accepting optional format)", hidden=true, response=BundleInstallationRestResult.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application, entity, or sensor not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response createFromYaml(@ApiParam(name="yaml", value="BOM YAML declaring the types to be installed", required=true) @Valid String var1, @ApiParam(name="force", value="Force installation including replacing any different bundle of the same name and version") @QueryParam(value="force") @DefaultValue(value="false") Boolean var2);

    @Deprecated
    @POST
    @Consumes(value={"application/deprecated-zip"})
    @ApiOperation(value="(deprecated; use same endpoint accepting optional format)", hidden=true, response=BundleInstallationRestResult.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application, entity, or sensor not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response createFromArchive(@ApiParam(name="archive", value="Bundle to install, in ZIP or JAR format, requiring catalog.bom containing bundle name and version", required=true) byte[] var1, @ApiParam(name="force", value="Whether to forcibly remove it, even if in use and/or errors", required=false, defaultValue="false") @QueryParam(value="force") @DefaultValue(value="false") Boolean var2);

    @POST
    @Consumes
    @ApiOperation(value="Add a bundle of types (entities, etc) to the type registry", notes="Format can be omitted for auto-detection, or supplied explicitly eg 'brooklyn-bom-bundle' to upload a ZIP/JAR containing a catalog.bom and optional other items", response=BundleInstallationRestResult.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Catalog items added successfully"), @ApiResponse(code=400, message="Error processing the given archive, or the catalog.bom is invalid"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response create(@ApiParam(name="archive", value="Bundle contents to install, eg for brooklyn-catalog-bundle a ZIP or JAR containing a catalog.bom file", required=true) byte[] var1, @ApiParam(name="format", value="Specify the format to indicate a specific resolver for handling this (auto-detect if omitted)", required=false) @QueryParam(value="format") @DefaultValue(value="") String var2, @ApiParam(name="force", value="Whether to forcibly remove it, even if in use and/or errors", required=false, defaultValue="false") @QueryParam(value="force") @DefaultValue(value="false") Boolean var3);

    @Path(value="/{symbolicName}/{version}/icon")
    @GET
    @ApiOperation(value="Gets the icon for a specific bundle given its symbolic name and version, if defined", response=BundleSummary.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Symbolic name not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response getIcon(@ApiParam(name="symbolicName", value="Bundle name to query", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="Version to query", required=true) @PathParam(value="version") String var2);
}

