/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLogger {
    private static final boolean ok;
    private final String className;
    private final Logger logger;

    public ClassLogger(String subsystem, String className) {
        this.logger = ok ? Logger.getLogger(subsystem) : null;
        this.className = className;
    }

    public final boolean traceOn() {
        return this.finerOn();
    }

    public final boolean debugOn() {
        return this.finestOn();
    }

    public final boolean warningOn() {
        return ok && this.logger.isLoggable(Level.WARNING);
    }

    public final boolean infoOn() {
        return ok && this.logger.isLoggable(Level.INFO);
    }

    public final boolean configOn() {
        return ok && this.logger.isLoggable(Level.CONFIG);
    }

    public final boolean fineOn() {
        return ok && this.logger.isLoggable(Level.FINE);
    }

    public final boolean finerOn() {
        return ok && this.logger.isLoggable(Level.FINER);
    }

    public final boolean finestOn() {
        return ok && this.logger.isLoggable(Level.FINEST);
    }

    public final void debug(String func, String msg) {
        this.finest(func, msg);
    }

    public final void debug(String func, Throwable t) {
        this.finest(func, t);
    }

    public final void debug(String func, String msg, Throwable t) {
        this.finest(func, msg, t);
    }

    public final void trace(String func, String msg) {
        this.finer(func, msg);
    }

    public final void trace(String func, Throwable t) {
        this.finer(func, t);
    }

    public final void trace(String func, String msg, Throwable t) {
        this.finer(func, msg, t);
    }

    public final void error(String func, String msg) {
        this.severe(func, msg);
    }

    public final void error(String func, Throwable t) {
        this.severe(func, t);
    }

    public final void error(String func, String msg, Throwable t) {
        this.severe(func, msg, t);
    }

    public final void finest(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.FINEST, this.className, func, msg);
        }
    }

    public final void finest(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINEST, this.className, func, t.toString(), t);
        }
    }

    public final void finest(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINEST, this.className, func, msg, t);
        }
    }

    public final void finer(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.FINER, this.className, func, msg);
        }
    }

    public final void finer(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINER, this.className, func, t.toString(), t);
        }
    }

    public final void finer(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINER, this.className, func, msg, t);
        }
    }

    public final void fine(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.FINE, this.className, func, msg);
        }
    }

    public final void fine(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINE, this.className, func, t.toString(), t);
        }
    }

    public final void fine(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.FINE, this.className, func, msg, t);
        }
    }

    public final void config(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.CONFIG, this.className, func, msg);
        }
    }

    public final void config(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.CONFIG, this.className, func, t.toString(), t);
        }
    }

    public final void config(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.CONFIG, this.className, func, msg, t);
        }
    }

    public final void info(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.INFO, this.className, func, msg);
        }
    }

    public final void info(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.INFO, this.className, func, t.toString(), t);
        }
    }

    public final void info(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.INFO, this.className, func, msg, t);
        }
    }

    public final void warning(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.WARNING, this.className, func, msg);
        }
    }

    public final void warning(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.WARNING, this.className, func, t.toString(), t);
        }
    }

    public final void warning(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.WARNING, this.className, func, msg, t);
        }
    }

    public final void severe(String func, String msg) {
        if (ok) {
            this.logger.logp(Level.SEVERE, this.className, func, msg);
        }
    }

    public final void severe(String func, Throwable t) {
        if (ok) {
            this.logger.logp(Level.SEVERE, this.className, func, t.toString(), t);
        }
    }

    public final void severe(String func, String msg, Throwable t) {
        if (ok) {
            this.logger.logp(Level.SEVERE, this.className, func, msg, t);
        }
    }

    static {
        boolean loaded = false;
        try {
            Class c = Logger.class;
            loaded = true;
        }
        catch (Error error) {
            // empty catch block
        }
        ok = loaded;
    }
}

