/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.feed;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.brooklyn.core.feed.AttributePollHandler;
import org.apache.brooklyn.core.feed.PollHandler;
import org.apache.brooklyn.util.text.Strings;

public class DelegatingPollHandler<V>
implements PollHandler<V> {
    private final List<AttributePollHandler<? super V>> delegates;

    public DelegatingPollHandler(Iterable<AttributePollHandler<? super V>> delegates) {
        this.delegates = ImmutableList.copyOf(delegates);
    }

    @Override
    public boolean checkSuccess(V val) {
        for (AttributePollHandler<V> delegate : this.delegates) {
            if (delegate.checkSuccess(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onSuccess(V val) {
        for (AttributePollHandler<V> delegate : this.delegates) {
            delegate.onSuccess(val);
        }
    }

    @Override
    public void onFailure(V val) {
        for (AttributePollHandler<V> delegate : this.delegates) {
            delegate.onFailure(val);
        }
    }

    @Override
    public void onException(Exception exception) {
        for (AttributePollHandler<V> delegate : this.delegates) {
            delegate.onException(exception);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getDescription() + "]";
    }

    @Override
    public String getDescription() {
        if (this.delegates.isEmpty()) {
            return "(empty delegate list)";
        }
        if (this.delegates.size() == 1) {
            return this.delegates.get(0).getDescription();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int count = 0;
        for (AttributePollHandler<V> delegate : this.delegates) {
            String d = delegate.getDescription();
            if (Strings.isNonBlank((CharSequence)d)) {
                if (count > 0) {
                    sb.append("; ");
                }
                sb.append(d);
            }
            if (count > 2) {
                sb.append("; ...");
                break;
            }
            ++count;
        }
        sb.append("]");
        return sb.toString();
    }
}

