/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.cloud.names;

import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.location.cloud.names.AbstractCloudMachineNamer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.text.StringShortener;
import org.apache.brooklyn.util.text.Strings;

public class BasicCloudMachineNamer
extends AbstractCloudMachineNamer {
    @Override
    protected String generateNewIdOfLength(ConfigBag setup, int len) {
        Object context = setup.peek(CloudLocationConfig.CALLER_CONTEXT);
        Entity entity = null;
        if (context instanceof Entity) {
            entity = (Entity)context;
        }
        StringShortener shortener = Strings.shortener();
        shortener.setAllowedCharacters(setup.get(CloudLocationConfig.VM_NAME_ALLOWED_CHARACTERS));
        shortener.separator("-");
        shortener.append("system", "brooklyn");
        shortener.append("timeStamp", Long.toString(System.currentTimeMillis() / 1000L, 36));
        String user = System.getProperty("user.name");
        if (!"brooklyn".equals(user)) {
            shortener.append("user", user);
        }
        if (entity != null) {
            Application app = entity.getApplication();
            if (app != null) {
                shortener.append("app", BasicCloudMachineNamer.shortName(app)).append("appId", app.getId());
            }
            shortener.append("entity", BasicCloudMachineNamer.shortName(entity)).append("entityId", entity.getId());
        } else if (context != null) {
            shortener.append("context", context.toString());
        }
        shortener.truncate("user", 12).truncate("app", 16).truncate("entity", 16).truncate("appId", 4).truncate("entityId", 4).truncate("context", 12);
        shortener.canTruncate("user", 8).canTruncate("app", 5).canTruncate("entity", 5).canTruncate("system", 2).canTruncate("app", 3).canTruncate("entity", 3).canRemove("app").canTruncate("user", 4).canRemove("entity").canTruncate("context", 4).canTruncate("timeStamp", 6).canRemove("user").canTruncate("appId", 2).canRemove("appId");
        String s = shortener.getStringOfMaxLength(len);
        return BasicCloudMachineNamer.sanitize(s).toLowerCase();
    }
}

