/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.brooklyn.core.mgmt.persist.ConfigLoader;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigLoader
implements ConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesConfigLoader.class);
    private String propertiesPath;

    protected PropertiesConfigLoader(String propertiesPath) {
        this.propertiesPath = propertiesPath;
    }

    @Override
    public Map<String, String> load() {
        LinkedHashMap linkedHashMap;
        InputStream resource = new ResourceUtils(PropertiesConfigLoader.class).getResourceFromUrl(this.propertiesPath);
        try {
            Properties props = new Properties();
            props.load(resource);
            LinkedHashMap result = Maps.newLinkedHashMap();
            Enumeration<?> iter = props.propertyNames();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                String value = props.getProperty(key);
                result.put(key, value);
            }
            linkedHashMap = result;
        }
        catch (IOException e) {
            try {
                try {
                    throw Exceptions.propagate((Throwable)e);
                }
                catch (Throwable throwable) {
                    Streams.closeQuietly((Closeable)resource);
                    throw throwable;
                }
            }
            catch (Exception e2) {
                LOG.warn("Failed to load properties file from " + this.propertiesPath + " (continuing)", (Throwable)e2);
                return ImmutableMap.of();
            }
        }
        Streams.closeQuietly((Closeable)resource);
        return linkedHashMap;
    }
}

