/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.common.annotations.Beta;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Predicate;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonSerializationUtils;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonType;
import org.apache.brooklyn.core.resolve.jackson.BrooklynRegisteredTypeJacksonSerialization;
import org.apache.brooklyn.core.resolve.jackson.CommonTypesSerialization;
import org.apache.brooklyn.core.resolve.jackson.ObjectReferencingSerialization;
import org.apache.brooklyn.core.resolve.jackson.WrappedValuesSerialization;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.apache.brooklyn.util.javalang.Boxing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWithTypeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BeanWithTypeUtils.class);
    public static final String FORMAT = "bean-with-type";
    static ThreadLocal<Stack<Object>> activeConversions = new ThreadLocal();

    public static ObjectMapper newMapper(ManagementContext mgmt, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowPojoJavaTypes) {
        return BeanWithTypeUtils.applyCommonMapperConfig((ObjectMapper)BeanWithTypeUtils.newSimpleMapper(), mgmt, allowRegisteredTypes, loader, allowPojoJavaTypes);
    }

    public static ObjectMapper newYamlMapper(ManagementContext mgmt, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowPojoJavaTypes) {
        return BeanWithTypeUtils.newYamlMapper(mgmt, allowRegisteredTypes, loader, allowPojoJavaTypes, false);
    }

    public static ObjectMapper newYamlMapper(ManagementContext mgmt, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowPojoJavaTypes, boolean allowYamlTagsForType) {
        ObjectMapper mapper = BeanWithTypeUtils.applyCommonMapperConfig((ObjectMapper)BeanWithTypeUtils.newSimpleYamlMapper(allowYamlTagsForType), mgmt, allowRegisteredTypes, loader, allowPojoJavaTypes);
        mapper = mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    public static ObjectMapper applyCommonMapperConfig(ObjectMapper mapper, ManagementContext mgmt, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowPojoJavaTypes) {
        mapper.enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);
        mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        BrooklynRegisteredTypeJacksonSerialization.apply(mapper, mgmt, allowRegisteredTypes, loader, allowPojoJavaTypes);
        WrappedValuesSerialization.apply(mapper, mgmt);
        mapper = new BrooklynJacksonSerializationUtils.ConfigurableBeanDeserializerModifier().addDeserializerWrapper(d -> new BrooklynJacksonSerializationUtils.JsonDeserializerForCommonBrooklynThings(mgmt, (JsonDeserializer<?>)d)).apply(mapper);
        CommonTypesSerialization.apply(mapper, mgmt);
        return mapper;
    }

    public static JsonMapper newSimpleMapper() {
        return (JsonMapper)JsonMapper.builder().build();
    }

    public static YAMLMapper newSimpleYamlMapper() {
        return BeanWithTypeUtils.newSimpleYamlMapper(false);
    }

    public static YAMLMapper newSimpleYamlMapper(boolean allowYamlTagsForType) {
        YAMLMapper result = ((YAMLMapper)YAMLMapper.builder().build()).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).disable(YAMLGenerator.Feature.SPLIT_LINES);
        if (!allowYamlTagsForType) {
            result.disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID);
        }
        return result;
    }

    public static boolean isPureJson(Object o) {
        return BeanWithTypeUtils.isJsonAndOthers(o, oo -> false);
    }

    public static boolean isJsonAndOthers(Object o, Predicate<Object> acceptOthers) {
        if (o instanceof String) {
            return true;
        }
        if (o == null) {
            return true;
        }
        if (Boxing.isPrimitiveOrBoxedObject((Object)o)) {
            return true;
        }
        if (o instanceof Collection) {
            for (Object oo : (Collection)o) {
                if (BeanWithTypeUtils.isJsonAndOthers(oo, acceptOthers)) continue;
                return false;
            }
            return true;
        }
        if (o instanceof Map) {
            for (Map.Entry oo : ((Map)o).entrySet()) {
                if (!BeanWithTypeUtils.isJsonAndOthers(oo.getKey(), acceptOthers)) {
                    return false;
                }
                if (BeanWithTypeUtils.isJsonAndOthers(oo.getValue(), acceptOthers)) continue;
                return false;
            }
            return true;
        }
        return acceptOthers.test(o);
    }

    public static boolean isJsonOrDeferredSupplier(Object o) {
        return BeanWithTypeUtils.isJsonAndOthers(o, oo -> oo instanceof DeferredSupplier);
    }

    public static <T> T convert(ManagementContext mgmt, Object mapOrListToSerializeThenDeserialize, TypeToken<T> type, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowJavaTypes) throws JsonProcessingException {
        Stack<Object> stack = activeConversions.get();
        if (stack == null) {
            stack = new Stack();
            activeConversions.set(stack);
        }
        if (stack.contains(mapOrListToSerializeThenDeserialize)) {
            throw new IllegalStateException("Aborting recursive attempt to convert '" + mapOrListToSerializeThenDeserialize + "'");
        }
        try {
            T result;
            stack.push(mapOrListToSerializeThenDeserialize);
            T t = result = BeanWithTypeUtils.convertShallow(mgmt, mapOrListToSerializeThenDeserialize, type, allowRegisteredTypes, loader, allowJavaTypes);
            return t;
        }
        catch (Exception e) {
            T t;
            try {
                t = BeanWithTypeUtils.convertDeeply(mgmt, mapOrListToSerializeThenDeserialize, type, allowRegisteredTypes, loader, allowJavaTypes);
            }
            catch (Exception e2) {
                throw Exceptions.propagate(Arrays.asList(e, e2));
            }
            return t;
        }
        finally {
            stack.pop();
            if (stack.isEmpty()) {
                activeConversions.remove();
            }
        }
    }

    @Beta
    public static <T> T convertShallow(ManagementContext mgmt, Object mapOrListToSerializeThenDeserialize, TypeToken<T> type, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowJavaTypes) throws JsonProcessingException {
        ObjectMapper mapper = YAMLMapper.builder().build();
        mapper = BeanWithTypeUtils.applyCommonMapperConfig(mapper, mgmt, allowRegisteredTypes, loader, allowJavaTypes);
        mapper = new ObjectReferencingSerialization().useAndApplytoMapper(mapper);
        String serialization = type.getRawType().equals(Object.class) ? mapper.writeValueAsString(mapOrListToSerializeThenDeserialize) : mapper.writerFor(Object.class).writeValueAsString(mapOrListToSerializeThenDeserialize);
        return (T)mapper.readValue(serialization, BrooklynJacksonType.asJavaType(mapper, type));
    }

    @Beta
    public static <T> T convertDeeply(ManagementContext mgmt, Object mapOrListToSerializeThenDeserialize, TypeToken<T> type, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowJavaTypes) throws JsonProcessingException {
        ObjectMapper mapper = BeanWithTypeUtils.newMapper(mgmt, allowRegisteredTypes, loader, allowJavaTypes);
        boolean useLonghandObjectWriter = true;
        if (type.getRawType().equals(Object.class)) {
            useLonghandObjectWriter = false;
        } else if (mapOrListToSerializeThenDeserialize == null || mapOrListToSerializeThenDeserialize instanceof String || Boxing.isPrimitiveOrBoxedObject((Object)mapOrListToSerializeThenDeserialize)) {
            useLonghandObjectWriter = false;
        }
        String serialization = !useLonghandObjectWriter ? mapper.writeValueAsString(mapOrListToSerializeThenDeserialize) : mapper.writerFor(Object.class).writeValueAsString(mapOrListToSerializeThenDeserialize);
        return (T)mapper.readValue(serialization, BrooklynJacksonType.asJavaType(mapper, type));
    }

    public static <T> Maybe<T> tryConvertOrAbsentUsingContext(Maybe<Object> input, TypeToken<T> type) {
        return BeanWithTypeUtils.tryConvertOrAbsentUsingContext(input, type, false);
    }

    public static <T> Maybe<T> tryConvertOrAbsentUsingContext(Maybe<Object> input, TypeToken<T> type, boolean allowNonMapComplexInput) {
        Entity entity = BrooklynTaskTags.getContextEntity(Tasks.current());
        ManagementContext mgmt = entity != null ? ((EntityInternal)entity).getManagementContext() : null;
        BrooklynClassLoadingContext loader = entity != null ? RegisteredTypes.getClassLoadingContext(entity) : null;
        return BeanWithTypeUtils.tryConvertOrAbsent(mgmt, input, type, true, loader, true, allowNonMapComplexInput);
    }

    public static <T> Maybe<T> tryConvertOrAbsent(ManagementContext mgmt, Maybe<Object> inputMap, TypeToken<T> type, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowJavaTypes) {
        return BeanWithTypeUtils.tryConvertOrAbsent(mgmt, inputMap, type, allowRegisteredTypes, loader, allowJavaTypes, false);
    }

    public static <T> Maybe<T> tryConvertOrAbsent(ManagementContext mgmt, Maybe<Object> inputMap, TypeToken<T> type, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowJavaTypes, boolean allowNonMapComplexInput) {
        if (inputMap.isAbsent()) {
            return inputMap;
        }
        Object o = inputMap.get();
        if (!(o instanceof Map || o instanceof List || Boxing.isPrimitiveOrBoxedObject((Object)o) || o instanceof String)) {
            if (type.isSupertypeOf(o.getClass())) {
                return inputMap;
            }
            if (!allowNonMapComplexInput) {
                return Maybe.absent(() -> new RuntimeException("BeanWithType cannot convert from " + o.getClass() + " to " + type));
            }
        }
        Maybe<Object> fallback = null;
        if (!BrooklynJacksonType.isRegisteredType(type)) {
            if (type.isSupertypeOf(Object.class)) {
                fallback = inputMap;
                if (!(o instanceof Map) || !((Map)o).containsKey("type")) {
                    return fallback;
                }
            } else if (type.isSupertypeOf(Map.class) && o instanceof Map) {
                return inputMap;
            }
        }
        try {
            return Maybe.ofDisallowingNull(BeanWithTypeUtils.convert(mgmt, o, type, allowRegisteredTypes, loader, allowJavaTypes));
        }
        catch (Exception e) {
            if (fallback != null) {
                return fallback;
            }
            return Maybe.absent((String)("BeanWithType cannot convert given input " + o + " to " + type), (Throwable)e);
        }
    }

    public static <T> boolean isConversionRecommended(Maybe<Object> input, TypeToken<T> type) {
        return BeanWithTypeUtils.getPotentialConvertibilityScoreInternal(input.orNull(), type) == 1;
    }

    public static <T> boolean isConversionPlausible(Maybe<Object> input, TypeToken<T> type) {
        if (input == null || input.isAbsentOrNull() || type == null) {
            return false;
        }
        return BeanWithTypeUtils.getPotentialConvertibilityScoreInternal(input.get(), type) >= 0;
    }

    private static <T> int getPotentialConvertibilityScoreInternal(Object t, TypeToken<T> type) {
        if (t == null) {
            return 0;
        }
        if (Boxing.isPrimitiveOrBoxedClass((Class)TypeTokens.getRawRawType(type)) || TypeTokens.equalsRaw(String.class, type)) {
            return TypeTokens.equalsRaw(t.getClass(), type) ? 0 : -1;
        }
        if (TypeTokens.equalsRaw(Object.class, type)) {
            return 0;
        }
        if (TypeTokens.isAssignableFromRaw(Map.class, type)) {
            if (t instanceof Map) {
                List generics = TypeTokens.getGenericArguments(type);
                if (generics != null) {
                    for (Map.Entry entry : ((Map)t).entrySet()) {
                        int k = BeanWithTypeUtils.getPotentialConvertibilityScoreInternal(entry.getKey(), (TypeToken)generics.get(0));
                        if (k != 0) {
                            return k;
                        }
                        int v = BeanWithTypeUtils.getPotentialConvertibilityScoreInternal(entry.getValue(), (TypeToken)generics.get(1));
                        if (v == 0) continue;
                        return v;
                    }
                }
                return 0;
            }
            return -1;
        }
        if (TypeTokens.isAssignableFromRaw(Collection.class, type)) {
            if (t instanceof Collection) {
                List generics = TypeTokens.getGenericArguments(type);
                if (generics != null) {
                    for (Object entry : (Collection)t) {
                        int k = BeanWithTypeUtils.getPotentialConvertibilityScoreInternal(entry, (TypeToken)generics.get(0));
                        if (k == 0) continue;
                        return k;
                    }
                }
                return 0;
            }
            return -1;
        }
        return t instanceof Map || t instanceof String || Boxing.isPrimitiveOrBoxedObject((Object)t) ? 1 : -1;
    }
}

