/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Objects;
import org.apache.brooklyn.core.resolve.jackson.WrappedValuesSerialization;
import org.apache.brooklyn.core.validation.BrooklynValidation;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.guava.Maybe;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WrappedValue<T>
implements java.util.function.Supplier<T>,
Supplier<T>,
DeferredSupplier<T> {
    static final WrappedValue<?> NULL_WRAPPED_VALUE = new WrappedValue(null, false);
    final T value;
    final java.util.function.Supplier<T> supplier;

    private WrappedValue(Object x, boolean isSupplier) {
        if (isSupplier) {
            this.supplier = (java.util.function.Supplier)x;
            this.value = null;
        } else {
            this.value = x;
            this.supplier = null;
        }
    }

    public static <T> WrappedValue<T> of(Object x) {
        if (x instanceof java.util.function.Supplier) {
            return WrappedValue.ofSupplier((java.util.function.Supplier)x);
        }
        if (x instanceof Supplier) {
            return WrappedValue.ofGuavaSupplier((Supplier)x);
        }
        return new WrappedValue<T>(x, false);
    }

    public static <T> WrappedValue<T> ofConstant(T x) {
        return new WrappedValue<T>(x, false);
    }

    public static <T> WrappedValue<T> ofSupplier(java.util.function.Supplier<T> x) {
        return new WrappedValue<T>(x, true);
    }

    public static <T> WrappedValue<T> ofGuavaSupplier(Supplier<T> x) {
        return new WrappedValue<T>(new GuavaSupplierAsJavaSupplier<T>(x), true);
    }

    public static <T> WrappedValue<T> ofNull() {
        return NULL_WRAPPED_VALUE;
    }

    @Override
    public T get() {
        return (T)BrooklynValidation.getInstance().ensureValid(this.supplier != null ? this.supplier.get() : this.value);
    }

    public java.util.function.Supplier<T> getSupplier() {
        return this.supplier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrappedValue that = (WrappedValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.supplier, that.supplier);
    }

    public String toString() {
        return "WrappedValue{" + (this.value != null ? "value=" + this.value : (this.supplier != null ? "supplier=" + this.supplier : "null")) + '}';
    }

    public int hashCode() {
        return Objects.hash(this.value, this.supplier);
    }

    public static <T> T get(WrappedValue<T> wrapper) {
        if (wrapper == null) {
            return null;
        }
        return wrapper.get();
    }

    public static <T> Maybe<T> getMaybe(WrappedValue<T> wrapper) {
        if (wrapper == null) {
            return Maybe.absent();
        }
        return Maybe.of(wrapper.get());
    }

    public static class WrappedValuesInitialized {
        public WrappedValuesInitialized() {
            WrappedValuesSerialization.ensureWrappedValuesInitialized(this);
        }
    }

    public static class GuavaSupplierAsJavaSupplier<T>
    implements java.util.function.Supplier<T> {
        final Supplier<T> guavaSupplier;

        private GuavaSupplierAsJavaSupplier() {
            this.guavaSupplier = null;
        }

        public GuavaSupplierAsJavaSupplier(Supplier<T> guavaSupplier) {
            this.guavaSupplier = (Supplier)Preconditions.checkNotNull(guavaSupplier);
        }

        @Override
        public T get() {
            return (T)this.guavaSupplier.get();
        }

        public Supplier<T> getGuavaSupplier() {
            return this.guavaSupplier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GuavaSupplierAsJavaSupplier that = (GuavaSupplierAsJavaSupplier)o;
            return Objects.equals(this.guavaSupplier, that.guavaSupplier);
        }

        public int hashCode() {
            return Objects.hash(this.guavaSupplier);
        }
    }
}

