/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group.zoneaware;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.entity.group.DynamicCluster;

public class CombiningZoneFailureDetector
implements DynamicCluster.ZoneFailureDetector {
    private final Predicate<? super List<Boolean>> joiner;
    private final List<DynamicCluster.ZoneFailureDetector> detectors;

    public static CombiningZoneFailureDetector failIfAny(DynamicCluster.ZoneFailureDetector ... detectors) {
        Predicate<List<Boolean>> joiner = new Predicate<List<Boolean>>(){

            public boolean apply(List<Boolean> input) {
                return input.contains(Boolean.TRUE);
            }
        };
        return new CombiningZoneFailureDetector((Predicate<? super List<Boolean>>)joiner, detectors);
    }

    public static CombiningZoneFailureDetector failIfAll(DynamicCluster.ZoneFailureDetector ... detectors) {
        Predicate<List<Boolean>> joiner = new Predicate<List<Boolean>>(){

            public boolean apply(List<Boolean> input) {
                return input.contains(Boolean.TRUE) && !input.contains(Boolean.FALSE) && !input.contains(null);
            }
        };
        return new CombiningZoneFailureDetector((Predicate<? super List<Boolean>>)joiner, detectors);
    }

    protected CombiningZoneFailureDetector(Predicate<? super List<Boolean>> joiner, DynamicCluster.ZoneFailureDetector ... detectors) {
        this.joiner = joiner;
        this.detectors = ImmutableList.copyOf((Object[])detectors);
    }

    @Override
    public void onStartupSuccess(Location loc, Entity entity) {
        for (DynamicCluster.ZoneFailureDetector detector : this.detectors) {
            detector.onStartupSuccess(loc, entity);
        }
    }

    @Override
    public void onStartupFailure(Location loc, Entity entity, Throwable cause) {
        for (DynamicCluster.ZoneFailureDetector detector : this.detectors) {
            detector.onStartupFailure(loc, entity, cause);
        }
    }

    @Override
    public boolean hasFailed(Location loc) {
        ArrayList opinions = Lists.newArrayList();
        for (DynamicCluster.ZoneFailureDetector detector : this.detectors) {
            detector.hasFailed(loc);
        }
        return this.joiner.apply((Object)opinions);
    }
}

