/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.stock.BasicStartableImpl;
import org.apache.brooklyn.entity.stock.ConditionalEntity;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalEntityImpl
extends BasicStartableImpl
implements ConditionalEntity {
    private static final Logger LOG = LoggerFactory.getLogger(BasicStartableImpl.class);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start(Collection<? extends Location> locations) {
        try {
            ServiceStateLogic.setExpectedState(this, Lifecycle.STARTING);
            this.sensors().set(Attributes.SERVICE_UP, false);
            Object val = this.config().get(START_LATCH);
            if (val != null) {
                LOG.debug("Finished waiting for start-latch in {}", (Object)this);
            }
            Entity entity = (Entity)this.sensors().get(CONDITIONAL_ENTITY);
            EntitySpec spec = (EntitySpec)this.config().get(CONDITIONAL_ENTITY_SPEC);
            Boolean create = (Boolean)this.config().get(CREATE_CONDITIONAL_ENTITY);
            Boolean propagate = (Boolean)this.config().get(PROPAGATE_CONDITIONAL_ENTITY_SENSORS);
            MutableSet sensors = MutableSet.copyOf((Iterable)((Iterable)this.config().get(CONDITIONAL_ENTITY_SENSOR_LIST)));
            Duration timeout = this.config().get(BrooklynConfigKeys.START_TIMEOUT);
            this.addLocations(locations);
            locations = Locations.getLocationsCheckingAncestors(locations, this);
            LOG.info("Starting entity {}: {}", (Object)this, locations);
            if (entity == null && spec != null && Boolean.TRUE.equals(create)) {
                Object t = this.addChild(EntitySpec.create((EntitySpec)spec));
                this.sensors().set(CONDITIONAL_ENTITY, t);
                this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{Startable.SERVICE_UP}).from((Entity)t)).build());
                this.enrichers().add(ServiceStateLogic.newEnricherFromChildrenState().suppressDuplicates(true).configure(ServiceStateLogic.ComputeServiceIndicatorsFromChildrenAndMembers.RUNNING_QUORUM_CHECK, QuorumCheck.QuorumChecks.all()));
                if (Boolean.TRUE.equals(propagate)) {
                    if (sensors.isEmpty()) {
                        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagatingAllButUsualAnd(new Sensor[0]).from((Entity)t)).build());
                    } else {
                        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating((Iterable)sensors).from((Entity)t)).build());
                    }
                }
            }
            if (Boolean.TRUE.equals(create)) {
                void var3_6;
                LOG.info("Starting child {}: {}", (Object)var3_6, locations);
                if (!Entities.invokeEffectorWithArgs(this, (Entity)var3_6, Startable.START, locations).blockUntilEnded(timeout)) throw new IllegalStateException(String.format("Timed out while %s was starting %s", this, var3_6));
                LOG.debug("Successfully started {} by {}", (Object)var3_6, (Object)this);
            } else {
                LOG.debug("No child created, setting SERVICE_UP to true");
                this.sensors().set(Attributes.SERVICE_UP, true);
            }
            ServiceStateLogic.setExpectedState(this, Lifecycle.RUNNING);
            return;
        }
        catch (Throwable t) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }
}

