/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.util.core.task.TaskInternalCancellableWithMode;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;

@Beta
public interface TaskInternal<T>
extends Task<T>,
TaskInternalCancellableWithMode {
    public void initInternalFuture(ListenableFuture<T> var1);

    public Future<T> getInternalFuture();

    public long getQueuedTimeUtc();

    public boolean isQueuedOrSubmitted();

    public boolean isQueuedAndNotSubmitted();

    public boolean isQueued();

    public void markQueued();

    public boolean cancel();

    public boolean blockUntilStarted(Duration var1);

    public String setBlockingDetails(String var1);

    public Task<?> setBlockingTask(Task<?> var1);

    public void resetBlockingDetails();

    public void resetBlockingTask();

    public String getBlockingDetails();

    public Task<?> getBlockingTask();

    public void setExtraStatusText(Object var1);

    public Object getExtraStatusText();

    public void runListeners();

    public void setEndTimeUtc(long var1);

    public void setThread(Thread var1);

    public Callable<T> getJob();

    public void setJob(Callable<T> var1);

    public ExecutionList getListeners();

    public void setSubmitTimeUtc(long var1);

    public void setSubmittedByTask(Task<?> var1);

    public void setSubmittedByTask(Maybe<Task<?>> var1, String var2);

    public Set<Object> getMutableTags();

    public void setStartTimeUtc(long var1);

    public void applyTagModifier(Function<Set<Object>, Void> var1);

    public Task<?> getProxyTarget();

    @Beta
    public static class TaskCancellationMode {
        public static final TaskCancellationMode DO_NOT_INTERRUPT = new TaskCancellationMode(false, false, false);
        public static final TaskCancellationMode INTERRUPT_TASK_BUT_NOT_SUBMITTED_TASKS = new TaskCancellationMode(true, false, false);
        public static final TaskCancellationMode INTERRUPT_TASK_AND_DEPENDENT_SUBMITTED_TASKS = new TaskCancellationMode(true, true, false);
        public static final TaskCancellationMode INTERRUPT_TASK_AND_ALL_SUBMITTED_TASKS = new TaskCancellationMode(true, true, true);
        private final boolean allowedToInterruptTask;
        private final boolean allowedToInterruptDependentSubmittedTasks;
        private final boolean allowedToInterruptAllSubmittedTasks;

        private TaskCancellationMode(boolean mayInterruptIfRunning, boolean interruptSubmittedTransients, boolean interruptAllSubmitted) {
            this.allowedToInterruptTask = mayInterruptIfRunning;
            this.allowedToInterruptDependentSubmittedTasks = interruptSubmittedTransients;
            this.allowedToInterruptAllSubmittedTasks = interruptAllSubmitted;
            assert (!this.allowedToInterruptAllSubmittedTasks || this.allowedToInterruptDependentSubmittedTasks);
        }

        public boolean isAllowedToInterruptTask() {
            return this.allowedToInterruptTask;
        }

        public boolean isAllowedToInterruptDependentSubmittedTasks() {
            return this.allowedToInterruptDependentSubmittedTasks;
        }

        public boolean isAllowedToInterruptAllSubmittedTasks() {
            return this.allowedToInterruptAllSubmittedTasks;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("interruptTask", this.allowedToInterruptTask).add("interruptDependentSubmitted", this.allowedToInterruptDependentSubmittedTasks).add("interruptAllSubmitted", this.allowedToInterruptAllSubmittedTasks).toString();
        }
    }
}

