/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.units;

import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.time.Duration;

public class DurationOrBoolean {
    final Duration durationSupplied;
    final Boolean booleanSupplied;

    private DurationOrBoolean() {
        this(null);
    }

    public DurationOrBoolean(Duration d) {
        this.durationSupplied = d;
        this.booleanSupplied = null;
    }

    public DurationOrBoolean(boolean b) {
        this.booleanSupplied = b;
        this.durationSupplied = null;
    }

    public static DurationOrBoolean fromString(String s) {
        if (s == null) {
            return null;
        }
        if (s.equalsIgnoreCase("true")) {
            return new DurationOrBoolean(true);
        }
        if (s.equalsIgnoreCase("false")) {
            return new DurationOrBoolean(false);
        }
        return new DurationOrBoolean(Duration.parse((String)s));
    }

    public Duration asDuration() {
        return this.durationSupplied != null ? this.durationSupplied : (this.booleanSupplied == null ? null : (this.booleanSupplied != false ? Duration.PRACTICALLY_FOREVER : Duration.ZERO));
    }

    public Duration getDurationSupplied() {
        return this.durationSupplied;
    }

    public Boolean getBooleanSupplied() {
        return this.booleanSupplied;
    }

    static {
        TypeCoercions.registerAdapter(DurationOrBoolean.class, Duration.class, DurationOrBoolean::asDuration);
        TypeCoercions.registerAdapter(Boolean.class, DurationOrBoolean.class, DurationOrBoolean::new);
        TypeCoercions.registerAdapter(Duration.class, DurationOrBoolean.class, DurationOrBoolean::new);
        TypeCoercions.registerAdapter(String.class, DurationOrBoolean.class, DurationOrBoolean::fromString);
    }
}

