/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.text.TemplateProcessor;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.stream.KnownSizeInputStream;
import org.apache.brooklyn.util.text.Strings;

public class DatastoreMixins {
    public static final AttributeSensor<String> DATASTORE_URL = HasDatastoreUrl.DATASTORE_URL;
    public static final Effector<String> EXECUTE_SCRIPT = CanExecuteScript.EXECUTE_SCRIPT;
    public static final ConfigKey<String> CREATION_SCRIPT_CONTENTS = CanGiveCreationScript.CREATION_SCRIPT_CONTENTS;
    public static final ConfigKey<String> CREATION_SCRIPT_URL = CanGiveCreationScript.CREATION_SCRIPT_URL;
    public static final ConfigKey<String> CREATION_SCRIPT_TEMPLATE = CanGiveCreationScript.CREATION_SCRIPT_TEMPLATE;

    private DatastoreMixins() {
    }

    @Nullable
    public static InputStream getDatabaseCreationScript(Entity entity) {
        String url = (String)entity.getConfig(CREATION_SCRIPT_URL);
        if (!Strings.isBlank((CharSequence)url)) {
            return new ResourceUtils((Object)entity).getResourceFromUrl(url);
        }
        String templateUrl = (String)entity.getConfig(CREATION_SCRIPT_TEMPLATE);
        if (!Strings.isBlank((CharSequence)templateUrl)) {
            String template = TemplateProcessor.processTemplateContents((String)("datastore mixin " + templateUrl), (String)new ResourceUtils((Object)entity).getResourceAsString(templateUrl), (EntityInternal)((EntityInternal)entity), (Map)ImmutableMap.of());
            try {
                return new ByteArrayInputStream(template.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        String contents = (String)entity.getConfig(CREATION_SCRIPT_CONTENTS);
        if (!Strings.isBlank((CharSequence)contents)) {
            return KnownSizeInputStream.of((String)contents);
        }
        return null;
    }

    @Nullable
    public static String getDatabaseCreationScriptAsString(Entity entity) {
        String url = (String)entity.getConfig(CREATION_SCRIPT_URL);
        if (!Strings.isBlank((CharSequence)url)) {
            return new ResourceUtils((Object)entity).getResourceAsString(url);
        }
        String templateUrl = (String)entity.getConfig(CREATION_SCRIPT_TEMPLATE);
        if (!Strings.isBlank((CharSequence)templateUrl)) {
            return TemplateProcessor.processTemplateContents((String)("datastore mixin " + templateUrl), (String)new ResourceUtils((Object)entity).getResourceAsString(templateUrl), (EntityInternal)((EntityInternal)entity), (Map)ImmutableMap.of());
        }
        String contents = (String)entity.getConfig(CREATION_SCRIPT_CONTENTS);
        if (!Strings.isBlank((CharSequence)contents)) {
            return contents;
        }
        return null;
    }

    public static interface DatastoreCommon
    extends Entity,
    HasDatastoreUrl,
    CanExecuteScript,
    CanGiveCreationScript {
    }

    public static interface CanGiveCreationScript {
        @CatalogConfig(label="Creation script contents")
        @SetFromFlag(value="creationScriptContents")
        public static final ConfigKey<String> CREATION_SCRIPT_CONTENTS = ConfigKeys.newStringConfigKey((String)"datastore.creation.script.contents", (String)"Contents of creation script to initialize the datastore", (String)"");
        @CatalogConfig(label="Creation script URL")
        @SetFromFlag(value="creationScriptUrl")
        public static final ConfigKey<String> CREATION_SCRIPT_URL = ConfigKeys.newStringConfigKey((String)"datastore.creation.script.url", (String)"URL of creation script to use to initialize the datastore (ignored if creationScriptContents is specified)", (String)"");
        @CatalogConfig(label="Creation script template URL")
        @SetFromFlag(value="creationScriptTemplateUrl")
        public static final ConfigKey<String> CREATION_SCRIPT_TEMPLATE = ConfigKeys.newStringConfigKey((String)"datastore.creation.script.template.url", (String)"URL of creation script Freemarker template used to initialize the datastore (ignored if datastore.creation.script.contents or datastore.creation.script.url is specified)", (String)"");
    }

    public static interface CanExecuteScript {
        public static final Effector<String> EXECUTE_SCRIPT = Effectors.effector(String.class, (String)"executeScript").description("executes the given script contents").parameter(ConfigKeys.newStringConfigKey((String)"commands")).buildAbstract();
    }

    public static interface HasDatastoreUrl {
        public static final AttributeSensor<String> DATASTORE_URL = Sensors.newStringSensor((String)"datastore.url", (String)"Primary contact URL for a datastore (e.g. mysql://localhost:3306/)");
    }
}

